/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.environment;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.DefaultGUIRegistry;
import repast.simphony.engine.environment.DefaultScheduleRegistry;
import repast.simphony.engine.environment.GUIRegistry;
import repast.simphony.engine.environment.RunInfo;
import repast.simphony.engine.environment.ScheduleRegistry;
import repast.simphony.random.DefaultRandomRegistry;
import repast.simphony.random.RandomHelper;
import repast.simphony.random.RandomRegistry;

public class RunState {
    private ScheduleRegistry scheduleRegistry;
    private RunInfo runInfo;
    private GUIRegistry guiRegistry;
    private Context masterContext;
    private Map<Object, Object> registry = new HashMap<Object, Object>();
    private ControllerRegistry controllerRegistry;
    private RandomRegistry randomRegistry;
    public static Context safeMasterContext = null;
    private static Map<Thread, RunState> runStates = new HashMap<Thread, RunState>();
    public static RunState staticInstance = null;

    public static void setSafeMasterContext(Context safeMasterContext) {
        RunState.safeMasterContext = safeMasterContext;
    }

    public static RunState init() {
        return RunState.setStaticInstance(new RunState());
    }

    public static RunState initDistributed() {
        RunState s = new RunState();
        runStates.put(Thread.currentThread(), s);
        RandomHelper.init();
        return s;
    }

    public static RunState init(RunInfo runInfo, ScheduleRegistry scheduleRegistry, GUIRegistry guiRegistry) {
        return RunState.setStaticInstance(new RunState(runInfo, scheduleRegistry, guiRegistry));
    }

    public static RunState getInstance() {
        if (staticInstance == null) {
            return runStates.get(Thread.currentThread());
        }
        return staticInstance;
    }

    private static RunState setStaticInstance(RunState staticInstance) {
        RunState.staticInstance = staticInstance;
        RandomHelper.init();
        return staticInstance;
    }

    RunState(RunInfo runInfo, ScheduleRegistry scheduleRegistry, GUIRegistry guiRegistry) {
        this.runInfo = runInfo;
        this.scheduleRegistry = scheduleRegistry;
        this.guiRegistry = guiRegistry;
        this.randomRegistry = new DefaultRandomRegistry();
    }

    RunState(RunInfo runInfo) {
        this(runInfo, new DefaultScheduleRegistry(), new DefaultGUIRegistry());
    }

    RunState() {
        this(null);
    }

    public RunInfo getRunInfo() {
        return this.runInfo;
    }

    public void setRunInfo(RunInfo runInfo) {
        this.runInfo = runInfo;
    }

    public ScheduleRegistry getScheduleRegistry() {
        return this.scheduleRegistry;
    }

    public void setScheduleRegistry(ScheduleRegistry scheduleRegistry) {
        this.scheduleRegistry = scheduleRegistry;
    }

    public GUIRegistry getGUIRegistry() {
        return this.guiRegistry;
    }

    public void setGUIRegistry(GUIRegistry guiRegistry) {
        this.guiRegistry = guiRegistry;
    }

    public void addToRegistry(Object key, Object value) {
        this.registry.put(key, value);
    }

    public Object removeFromRegistry(Object key) {
        return this.registry.remove(key);
    }

    public Object getFromRegistry(Object key) {
        return this.registry.get(key);
    }

    public void setMasterContext(Context masterContext) {
        this.masterContext = masterContext;
    }

    public Context getMasterContext() {
        return this.masterContext;
    }

    public static Context getSafeMasterContext() {
        if (RunState.getInstance().getMasterContext() == null) {
            return safeMasterContext;
        }
        safeMasterContext = null;
        return RunState.getInstance().getMasterContext();
    }

    public void setControllerRegistry(ControllerRegistry controllerRegistry) {
        this.controllerRegistry = controllerRegistry;
    }

    public ControllerRegistry getControllerRegistry() {
        return this.controllerRegistry;
    }

    public RandomRegistry getRandomRegistry() {
        return this.randomRegistry;
    }

    public void setRandomRegistry(RandomRegistry registry) {
        this.randomRegistry = registry;
        RandomHelper.init();
    }
}

