/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.environment;

import repast.simphony.engine.environment.RunListener;
import repast.simphony.engine.environment.Runner;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.parameter.Parameters;

public class RunEnvironment {
    public static int DEFAULT_SPARKLINE_LENGTH = 50;
    public static boolean DEFAULT_SPARKLINE_TYPE = true;
    private int sparklineLength = DEFAULT_SPARKLINE_LENGTH;
    private boolean sparklineLineType = DEFAULT_SPARKLINE_TYPE;
    private int scheduleTickDelay = 0;
    private static RunEnvironment instance;
    private ISchedule schedule;
    private Runner scheduleRunner;
    private ISchedulableAction pauseAction;
    private ISchedulableAction stopAction;
    private boolean isBatch = false;
    private Parameters parameters;

    public int getScheduleTickDelay() {
        return this.scheduleTickDelay;
    }

    public void setScheduleTickDelay(int scheduleTickDelay) {
        this.scheduleTickDelay = scheduleTickDelay;
    }

    public boolean getSparklineType() {
        return this.sparklineLineType;
    }

    public void setSparklineType(boolean sparklineType) {
        this.sparklineLineType = sparklineType;
    }

    public int getSparklineLength() {
        return this.sparklineLength;
    }

    public void setSparklineLength(int sparklineLength) {
        this.sparklineLength = sparklineLength;
    }

    public static RunEnvironment getInstance() {
        return instance;
    }

    private RunEnvironment(ISchedule schedule, Runner scheduleRunner, Parameters parameters, boolean isBatch) {
        this.schedule = schedule;
        this.scheduleRunner = scheduleRunner;
        this.isBatch = isBatch;
        this.parameters = parameters;
    }

    public static void init(ISchedule schedule, Runner scheduleRunner, Parameters parameters, boolean isBatch) {
        instance = new RunEnvironment(schedule, scheduleRunner, parameters, isBatch);
    }

    public ISchedule getCurrentSchedule() {
        return this.schedule;
    }

    public void pauseAt(double tick) {
        if (this.pauseAction != null) {
            this.schedule.removeAction(this.pauseAction);
        }
        this.pauseAction = this.schedule.schedule(ScheduleParameters.createOneTime(tick), new PauseAction());
    }

    public void pauseRun() {
        this.scheduleRunner.setPause(true);
    }

    public void resumeRun() {
        this.scheduleRunner.setPause(false);
    }

    public void endAt(double tick) {
        if (this.stopAction != null) {
            this.schedule.removeAction(this.stopAction);
        }
        this.stopAction = this.schedule.schedule(ScheduleParameters.createOneTime(tick), new StopAction());
    }

    public void endRun() {
        this.scheduleRunner.stop();
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters params) {
        this.parameters = params;
    }

    public void addRunListener(RunListener runListener) {
        this.scheduleRunner.addRunListener(runListener);
    }

    public void removeRunListener(RunListener runListener) {
        this.scheduleRunner.removeRunListener(runListener);
    }

    private class PauseAction
    implements IAction {
        private static final long serialVersionUID = 98732418679L;

        private PauseAction() {
        }

        @Override
        public void execute() {
            RunEnvironment.this.scheduleRunner.setPause(true);
        }
    }

    private class StopAction
    implements IAction {
        private static final long serialVersionUID = 198464767L;

        private StopAction() {
        }

        @Override
        public void execute() {
            RunEnvironment.this.scheduleRunner.stop();
        }
    }
}

