/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import repast.simphony.engine.environment.GUIRegistry;
import repast.simphony.engine.environment.GUIRegistryType;
import repast.simphony.util.collections.Pair;
import repast.simphony.visualization.IDisplay;

public class DefaultGUIRegistry
implements GUIRegistry {
    private Hashtable<GUIRegistryType, ArrayList<JComponent>> typeComponentTable;
    private Hashtable<JComponent, GUIRegistryType> componentTypeTable;
    private HashMap<JComponent, String> componentNameTable;
    private Map<JComponent, IDisplay> compDisplayMap = new HashMap<JComponent, IDisplay>();

    public DefaultGUIRegistry() {
        this.typeComponentTable = new Hashtable();
        this.componentNameTable = new HashMap();
        this.componentTypeTable = new Hashtable();
    }

    @Override
    public void addComponent(JComponent component, GUIRegistryType type, String name) {
        Collection<JComponent> components = this.getComponents(type);
        components.add(component);
        this.componentNameTable.put(component, name);
        this.componentTypeTable.put(component, type);
    }

    @Override
    public boolean removeComponent(JComponent component) {
        GUIRegistryType type = this.componentTypeTable.remove(component);
        if (type != null) {
            this.getComponents(type).remove(component);
            this.componentTypeTable.remove(component);
            return this.componentNameTable.remove(component) != null;
        }
        return false;
    }

    private Collection<JComponent> getComponents(GUIRegistryType type) {
        if (this.typeComponentTable.get((Object)type) == null) {
            this.typeComponentTable.put(type, new ArrayList());
        }
        return this.typeComponentTable.get((Object)type);
    }

    @Override
    public String getName(JComponent component) {
        return this.componentNameTable.get(component);
    }

    @Override
    public Collection<Pair<GUIRegistryType, Collection<JComponent>>> getTypesAndComponents() {
        ArrayList<Pair<GUIRegistryType, Collection<JComponent>>> typeComponentPairs = new ArrayList<Pair<GUIRegistryType, Collection<JComponent>>>();
        for (GUIRegistryType type : this.typeComponentTable.keySet()) {
            typeComponentPairs.add(new Pair<GUIRegistryType, Collection>(type, this.typeComponentTable.get((Object)type)));
        }
        return typeComponentPairs;
    }

    @Override
    public void addDisplay(String name, GUIRegistryType type, IDisplay display) {
        JPanel panel = display.getPanel();
        this.addComponent(panel, type, name);
        this.compDisplayMap.put(panel, display);
    }

    @Override
    public List<IDisplay> getDisplays() {
        return new ArrayList<IDisplay>(this.compDisplayMap.values());
    }

    @Override
    public IDisplay getDisplayForComponent(JComponent comp) {
        return this.compDisplayMap.get(comp);
    }
}

