/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.environment;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.engine.controller.Controller;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.engine.environment.RunListener;
import repast.simphony.engine.environment.Runner;

public abstract class AbstractRunner
implements Runner {
    protected boolean stop = false;
    protected boolean pause = false;
    protected boolean step = false;
    protected ArrayList<RunListener> runListeners = new ArrayList();
    protected Thread thread;
    protected RunEnvironmentBuilder environmentBuilder;
    protected Controller controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRunListener(RunListener listener) {
        ArrayList<RunListener> arrayList = this.runListeners;
        synchronized (arrayList) {
            this.runListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunListener(RunListener listener) {
        ArrayList<RunListener> arrayList = this.runListeners;
        synchronized (arrayList) {
            this.runListeners.remove(listener);
        }
    }

    protected void fireStartedMessage() {
        List<RunListener> list = this.cloneListenerList();
        for (RunListener listener : list) {
            listener.started();
        }
    }

    protected void fireStoppedMessage() {
        List<RunListener> list = this.cloneListenerList();
        for (RunListener listener : list) {
            listener.stopped();
        }
    }

    @Override
    public void setEnvironmentBuilder(RunEnvironmentBuilder environment) {
        this.environmentBuilder = environment;
    }

    protected void firePausedMessage() {
        List<RunListener> list = this.cloneListenerList();
        for (RunListener listener : list) {
            listener.paused();
        }
    }

    protected void fireRestartedMessage() {
        List<RunListener> list = this.cloneListenerList();
        for (RunListener listener : list) {
            listener.restarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RunListener> cloneListenerList() {
        List list = null;
        ArrayList<RunListener> arrayList = this.runListeners;
        synchronized (arrayList) {
            list = (List)this.runListeners.clone();
        }
        return list;
    }

    @Override
    public void init() {
        this.stop = false;
        this.pause = false;
        this.step = false;
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public void step() {
        this.step = true;
    }

    @Override
    public void setPause(boolean pause) {
        this.pause = pause;
    }

    @Override
    public boolean go() {
        return !this.stop;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }
}

