/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.controller;

import repast.simphony.context.Context;
import repast.simphony.context.ContextListener;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.engine.watcher.WatcherTrigger;
import repast.simphony.parameter.Parameters;

public class WatcherControllerAction
implements ControllerAction {
    private WatchAnnotationReader reader;

    public WatcherControllerAction(WatchAnnotationReader reader) {
        this.reader = reader;
    }

    public int watchCount() {
        return this.reader.watchCount();
    }

    @Override
    public void runInitialize(RunState runState, Object contextId, Parameters runParams) {
        Context context = runState.getMasterContext();
        ISchedule schedule = runState.getScheduleRegistry().getModelSchedule();
        ContextListener contextListener = this.reader.getContextListener(schedule);
        boolean doSetup = true;
        for (ContextListener obj : context.getContextListeners()) {
            if (!obj.equals(contextListener)) continue;
            doSetup = false;
            break;
        }
        if (context != null && doSetup) {
            context.addContextListener(contextListener);
            this.reader.processObjectAsWatcher(context, schedule, context);
            for (Class clazz : context.getAgentTypes()) {
                for (Object obj : context.getObjects(clazz)) {
                    this.reader.processObjectAsWatcher(obj, schedule, context);
                }
            }
        }
    }

    @Override
    public void batchInitialize(RunState runState, Object contextId) {
    }

    @Override
    public void runCleanup(RunState runState, Object contextId) {
        WatcherTrigger.getInstance().clearNotifiers();
        this.reader.reset();
    }

    @Override
    public void batchCleanup(RunState runState, Object contextId) {
    }
}

