/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.controller;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.engine.controller.ClassFilter;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.DynamicTargetAction;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.schedule.ScheduledMethod;
import repast.simphony.parameter.Parameters;

public class ScheduledMethodControllerAction
implements ControllerAction,
ContextListener {
    private List<PickData> pickData = new ArrayList<PickData>();
    private Set<Class<?>> processedClasses = new HashSet();
    private Set<Method> processedMethods = new HashSet<Method>();
    private ISchedule schedule;
    private Map<Object, ISchedulableAction> contextActions = new HashMap<Object, ISchedulableAction>();

    public ScheduledMethodControllerAction() {
    }

    public ScheduledMethodControllerAction(List<Class<?>> clazzes) {
        this.processAnnotations(clazzes);
    }

    public void processAnnotations(List<Class<?>> clazzes) {
        for (Class<?> clazz : clazzes) {
            this.processAnnotations(clazz);
        }
        for (Class<?> clazz : clazzes) {
            HashSet interfaces = new HashSet();
            this.gatherInterfaces(clazz, interfaces);
            for (Class clazz2 : interfaces) {
                if (this.processedClasses.contains(clazz2)) continue;
                this.processAnnotations(clazz2);
            }
        }
    }

    private void gatherInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        Class<?>[] inters;
        if (clazz.equals(Object.class)) {
            return;
        }
        Class<?>[] classArray = inters = clazz.getInterfaces();
        int n = inters.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            interfaces.add(inter);
            this.gatherInterfaces(inter, interfaces);
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            this.gatherInterfaces(clazz.getSuperclass(), interfaces);
        }
    }

    public void processAnnotations(Class<?> clazz) {
        if (!Context.class.isAssignableFrom(clazz)) {
            Method[] methods;
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!this.processedMethods.contains(method)) {
                    this.processMethod(method);
                }
                ++n2;
            }
            this.processedClasses.add(clazz);
        }
    }

    private PickData processMethod(Method method) {
        ScheduledMethod schedule = method.getAnnotation(ScheduledMethod.class);
        if (schedule != null) {
            PickData data = new PickData(method, schedule);
            this.pickData.add(data);
            this.processedMethods.add(method);
            return data;
        }
        return null;
    }

    @Override
    public void batchInitialize(RunState runState, Object contextId) {
    }

    private void processContext(Context context) {
        Class<?> clazz = context.getClass();
        if (!this.processedClasses.contains(clazz)) {
            Method[] methods;
            boolean found = false;
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                PickData data = this.processMethod(method);
                if (data != null) {
                    data.target = context;
                    found = true;
                }
                ++n2;
            }
            if (found) {
                context.addContextListener(this);
            }
            this.processedClasses.add(clazz);
        }
        for (Context child : context.getSubContexts()) {
            this.processContext(child);
        }
    }

    @Override
    public void runInitialize(RunState runState, Object contextId, Parameters runParams) {
        Context context = runState.getMasterContext();
        this.processContext(context);
        this.schedule = runState.getScheduleRegistry().getModelSchedule();
        this.findClassesToExclude();
        this.scheduleMethods(context, this.schedule);
    }

    private void findClassesToExclude() {
        for (PickData data : this.pickData) {
            Class<?> clazz = data.method.getDeclaringClass();
            for (PickData other : this.pickData) {
                Class<?> otherClass = other.method.getDeclaringClass();
                if (!clazz.isAssignableFrom(otherClass) || clazz.equals(otherClass) || !data.method.getName().equals(other.method.getName()) || !data.method.getReturnType().equals(other.method.getReturnType())) continue;
                data.excludes.add(otherClass);
            }
        }
    }

    private ClassFilter createFilter(PickData data) {
        Class[] classes = data.excludes.toArray(new Class[0]);
        return ClassFilter.getNotEqualsFilter(classes);
    }

    private void scheduleMethods(Context context, ISchedule schedule) {
        for (PickData data : this.pickData) {
            IAction action;
            ClassFilter filter;
            IAction action2;
            if (Modifier.isStatic(data.method.getModifiers())) {
                action2 = new StaticMethodAction(new DynamicTargetAction(data.method));
                schedule.schedule(data.getParameters(), action2);
                continue;
            }
            if (data.target != null) {
                action2 = new DynamicTargetAction(data.method);
                ((DynamicTargetAction)action2).setTarget(data.target);
                ISchedulableAction schAction = schedule.schedule(data.getParameters(), action2);
                this.contextActions.put(data.target, schAction);
                continue;
            }
            if (data.annotation.pick() == Long.MAX_VALUE) {
                filter = this.createFilter(data);
                action = new ScheduleMethodAllAction(context, data.method.getDeclaringClass(), data.method, data.shuffle, filter);
                schedule.schedule(data.getParameters(), action);
                continue;
            }
            filter = this.createFilter(data);
            action = new ScheduleMethodAction(context, data.method.getDeclaringClass(), data.method, data.annotation.pick(), data.shuffle, filter);
            schedule.schedule(data.getParameters(), action);
        }
    }

    @Override
    public void runCleanup(RunState runState, Object contextId) {
        this.processedClasses.clear();
        this.processedMethods.clear();
        this.contextActions.clear();
        Iterator<PickData> iter = this.pickData.iterator();
        while (iter.hasNext()) {
            PickData data = iter.next();
            if (data.target == null || !(data.target instanceof Context)) continue;
            iter.remove();
        }
    }

    @Override
    public void batchCleanup(RunState runState, Object contextId) {
    }

    public void eventOccured(ContextEvent ev) {
        ContextEvent.EventType type = ev.getType();
        if (type == ContextEvent.EventType.SUBCONTEXT_ADDED) {
            this.processContext(ev.getSubContext());
        } else if (type == ContextEvent.EventType.SUBCONTEXT_REMOVED) {
            ISchedulableAction action = this.contextActions.get(ev.getSubContext());
            this.schedule.removeAction(action);
        }
    }

    static class PickData {
        Object target;
        Method method;
        ScheduledMethod annotation;
        long pickCount = 0L;
        boolean shuffle = true;
        Set<Class<?>> excludes = new HashSet();

        public PickData(Method method, ScheduledMethod annotation) {
            this.method = method;
            this.annotation = annotation;
            this.shuffle = this.annotation.shuffle();
        }

        public ScheduleParameters getParameters() {
            double duration = this.annotation.duration();
            ScheduleParameters params = this.annotation.start() == Double.POSITIVE_INFINITY ? ScheduleParameters.createAtEnd(this.annotation.priority()) : (this.annotation.interval() > 0.0 ? ScheduleParameters.createRepeating(this.annotation.start(), this.annotation.interval(), this.annotation.priority(), duration) : ScheduleParameters.createOneTime(this.annotation.start(), this.annotation.priority(), duration));
            return params;
        }
    }

    private static class ScheduleMethodAction
    implements IAction {
        private Context<Object> context;
        private Class<?> targetClass;
        private DynamicTargetAction action;
        private long count;
        boolean shuffle;
        ClassFilter filter;

        public ScheduleMethodAction(Context<Object> context, Class<?> targetClass, Method method, long count, boolean shuffle, ClassFilter filter) {
            this.context = context;
            this.targetClass = targetClass;
            this.action = new DynamicTargetAction(method);
            this.count = count;
            this.shuffle = shuffle;
            this.filter = filter;
        }

        @Override
        public void execute() {
            if (this.shuffle) {
                for (Object object : this.context.getRandomObjects(this.targetClass, this.count)) {
                    if (!this.filter.apply(object.getClass())) continue;
                    this.action.setTarget(object);
                    this.action.execute();
                }
            } else {
                for (Object t : this.context.getObjects(this.targetClass)) {
                    if (!this.filter.apply(t.getClass())) continue;
                    this.action.setTarget(t);
                    this.action.execute();
                }
            }
        }
    }

    private static class ScheduleMethodAllAction
    implements IAction {
        private Context<Object> context;
        private Class<?> targetClass;
        private DynamicTargetAction action;
        private boolean shuffle;
        private ClassFilter filter;

        public ScheduleMethodAllAction(Context<Object> context, Class<?> targetClass, Method method, boolean shuffle, ClassFilter filter) {
            this.context = context;
            this.targetClass = targetClass;
            this.action = new DynamicTargetAction(method);
            this.shuffle = shuffle;
            this.filter = filter;
        }

        @Override
        public void execute() {
            Iterable<Object> iter = this.shuffle ? this.context.getRandomObjects(this.targetClass, this.context.size()) : this.context.getObjects(this.targetClass);
            for (Object t : iter) {
                if (!this.filter.apply(t.getClass())) continue;
                this.action.setTarget(t);
                this.action.execute();
            }
        }
    }

    private static class StaticMethodAction
    implements IAction {
        private DynamicTargetAction action;

        private StaticMethodAction(DynamicTargetAction action) {
            this.action = action;
        }

        @Override
        public void execute() {
            this.action.execute();
        }
    }
}

