/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.util.collections.NaryTree;
import repast.simphony.util.collections.Tree;

public class DefaultControllerRegistry
implements ControllerRegistry {
    private Map<Object, Tree<ControllerAction>> contextActionMap;
    private Tree<Object> contextTree;
    private Object masterContextId = "MasterContextID";
    private String name = "";
    private Map<Object, Map<String, ControllerAction>> actionMap = new HashMap<Object, Map<String, ControllerAction>>();
    protected ArrayList<ParameterSetter> paramSetters;

    public DefaultControllerRegistry() {
        this.contextActionMap = new HashMap<Object, Tree<ControllerAction>>();
        this.contextTree = new NaryTree<Object>(this.masterContextId);
        this.paramSetters = new ArrayList();
    }

    @Override
    public ControllerRegistry clone() {
        try {
            return (ControllerRegistry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void addAction(Object contextId, ControllerAction parent, ControllerAction action) {
        Tree<ControllerAction> tree;
        if (parent == null) {
            parent = ControllerRegistry.ACTION_TREE_ROOT;
        }
        if ((tree = this.getActionTree(contextId)) == null) {
            tree = new NaryTree<ControllerAction>(ControllerRegistry.ACTION_TREE_ROOT);
            this.contextActionMap.put(contextId, tree);
        }
        tree.addNode(parent, action);
    }

    @Override
    public Tree<ControllerAction> getActionTree(Object contextId) {
        return this.contextActionMap.get(contextId);
    }

    @Override
    public boolean removeAction(Object contextId, ControllerAction action) {
        Tree<ControllerAction> tree = this.getActionTree(contextId);
        if (tree != null) {
            this.removeActionFromMap(contextId, action);
            return tree.removeNode(action);
        }
        return false;
    }

    private void removeActionFromMap(Object contextID, ControllerAction action) {
        Map<String, ControllerAction> actions = this.actionMap.get(contextID);
        if (actions != null) {
            for (String key : actions.keySet()) {
                if (!actions.get(key).equals(action)) continue;
                actions.remove(key);
                break;
            }
        }
    }

    @Override
    public void replaceAction(Object contextId, ControllerAction oldAction, ControllerAction newAction) {
        this.getActionTree(contextId).replaceNode(oldAction, newAction);
        Map<String, ControllerAction> actions = this.actionMap.get(contextId);
        if (actions != null) {
            for (String key : actions.keySet()) {
                if (!actions.get(key).equals(oldAction)) continue;
                actions.remove(key);
                actions.put(key, newAction);
                break;
            }
        }
    }

    @Override
    public Tree<Object> getContextIdTree() {
        return this.contextTree;
    }

    @Override
    public void addContextId(Object parentId, Object newId) {
        this.contextTree.addNode(parentId, newId);
    }

    @Override
    public void removeContextId(Object id) {
        this.contextTree.removeNode(id);
        this.actionMap.remove(id);
    }

    @Override
    public void setMasterContextId(Object id) {
        this.replaceContextId(this.masterContextId, id);
        Map<String, ControllerAction> actions = this.actionMap.remove(this.masterContextId);
        if (actions != null) {
            this.actionMap.put(id, actions);
        }
        this.masterContextId = id;
    }

    @Override
    public Object getMasterContextId() {
        return this.masterContextId;
    }

    @Override
    public void replaceContextId(Object idToReplace, Object newId) {
        this.contextTree.replaceNode(idToReplace, newId);
        Map<String, ControllerAction> actions = this.actionMap.remove(idToReplace);
        if (actions != null) {
            this.actionMap.put(newId, actions);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void registerAction(Object contextID, String id, ControllerAction action) {
        Map<String, ControllerAction> actions = this.actionMap.get(contextID);
        if (actions == null) {
            actions = new HashMap<String, ControllerAction>();
            this.actionMap.put(contextID, actions);
        }
        actions.put(id, action);
    }

    @Override
    public ControllerAction findAction(Object contextID, String actionID) {
        Map<String, ControllerAction> actions = this.actionMap.get(contextID);
        if (actions == null) {
            return null;
        }
        return actions.get(actionID);
    }

    @Override
    public void addParameterSetter(ParameterSetter paramInit) {
        this.paramSetters.add(paramInit);
    }

    @Override
    public void removeParameterSetter(ParameterSetter paramInit) {
        this.paramSetters.remove(paramInit);
    }

    @Override
    public Collection<ParameterSetter> getParameterSetters() {
        return Collections.unmodifiableCollection(this.paramSetters);
    }
}

