/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.controller;

import java.util.Collection;
import java.util.Comparator;
import repast.simphony.context.Context;
import repast.simphony.engine.controller.Controller;
import repast.simphony.engine.controller.DefaultRandomStreamAction;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.DefaultControllerAction;
import repast.simphony.engine.environment.DefaultScheduleRunner;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.engine.environment.RunInfo;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.environment.Runner;
import repast.simphony.parameter.DefaultParameters;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.random.DefaultRandomRegistry;
import repast.simphony.util.collections.Tree;
import repast.simphony.util.collections.TreeVisitor;
import simphony.util.messages.MessageCenter;

public class DefaultController
implements Controller {
    private static final int FIRST_RUN_NUMBER = 1;
    private static final long serialVersionUID = -202102336096207785L;
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(DefaultController.class);
    Integer runNumber;
    private RunEnvironmentBuilder runEnvironmentBuilder;
    private ControllerRegistry actionRegistry;
    private RunState currentRunState;
    private boolean runStateSetInBatch = false;
    private int nextBatchNumber = 1;
    private int nextRunNumber = 1;
    private int currentBatchNumber = 1;
    private Runner scheduleRunner = new DefaultScheduleRunner();
    private RunEnvironment currentRunEnvironment;

    public DefaultController(RunEnvironmentBuilder runEnvironmentBuilder) {
        this.runEnvironmentBuilder = runEnvironmentBuilder;
    }

    public DefaultController(RunEnvironmentBuilder runEnvironmentBuilder, int runNumber) {
        this.runEnvironmentBuilder = runEnvironmentBuilder;
        this.runNumber = runNumber;
    }

    @Override
    public void setControllerRegistry(ControllerRegistry controllerRegistry) {
        this.actionRegistry = controllerRegistry;
    }

    @Override
    public ControllerRegistry getControllerRegistry() {
        return this.actionRegistry;
    }

    @Override
    public void setScheduleRunner(Runner scheduleRunner) {
        this.scheduleRunner = scheduleRunner;
    }

    @Override
    public Runner getScheduleRunner() {
        return this.scheduleRunner;
    }

    private void batchInitialize(final RunState runState, final Object contextId) {
        Tree<ControllerAction> tree = this.actionRegistry.getActionTree(contextId);
        tree.sortChildren(new DefaultActionComparator(contextId));
        tree.preOrderTraversal(new TreeVisitor<ControllerAction>(){

            @Override
            public void visit(ControllerAction node) {
                node.batchInitialize(runState, contextId);
            }
        });
        for (Object id : this.actionRegistry.getContextIdTree().getChildren(contextId)) {
            this.batchInitialize(runState, id);
        }
    }

    private void runInitialize(final RunState runState, Object contextTypeId, final Object contextInstanceId, final Parameters runParams) {
        Tree<ControllerAction> tree = this.actionRegistry.getActionTree(contextTypeId);
        tree.sortChildren(new DefaultActionComparator(contextTypeId));
        tree.preOrderTraversal(new TreeVisitor<ControllerAction>(){

            @Override
            public void visit(ControllerAction node) {
                node.runInitialize(runState, contextInstanceId, runParams);
            }
        });
    }

    private void runInitialize(final RunState runState, final Context context, final Parameters runParams) {
        Tree<ControllerAction> tree = this.actionRegistry.getActionTree(context.getTypeID());
        if (tree == null && context.getTypeID().toString().indexOf("__Synthetic_Context__") != -1) {
            msgCenter.warn((Object)"Unable to initialize a subcontext: check that subcontext constructors are passed the correct name", new Object[0]);
            throw new RuntimeException("Unable to initialize an unfound context");
        }
        if (tree != null) {
            tree.sortChildren(new DefaultActionComparator(context.getTypeID()));
            tree.preOrderTraversal(new TreeVisitor<ControllerAction>(){

                @Override
                public void visit(ControllerAction node) {
                    node.runInitialize(runState, context.getId(), runParams);
                }
            });
        }
        Iterable subIter = context.getSubContexts();
        for (Context sub : subIter) {
            this.runInitialize(runState, sub, runParams);
        }
    }

    public void batchCleanup(final RunState runState, final Object contextId) {
        Tree<ControllerAction> tree = this.actionRegistry.getActionTree(contextId);
        tree.preOrderTraversal(new TreeVisitor<ControllerAction>(){

            @Override
            public void visit(ControllerAction node) {
                node.batchCleanup(runState, contextId);
            }
        });
        for (Object id : this.actionRegistry.getContextIdTree().getChildren(contextId)) {
            this.batchCleanup(runState, id);
        }
    }

    public void runCleanup(final RunState runState, final Object contextId) {
        Tree<ControllerAction> tree = this.actionRegistry.getActionTree(contextId);
        tree.preOrderTraversal(new TreeVisitor<ControllerAction>(){

            @Override
            public void visit(ControllerAction node) {
                node.runCleanup(runState, contextId);
            }
        });
        for (Object id : this.actionRegistry.getContextIdTree().getChildren(contextId)) {
            this.runCleanup(runState, id);
        }
        runState.setGUIRegistry(null);
    }

    public void execute(RunState toExecuteOn) {
        this.scheduleRunner.execute(toExecuteOn);
    }

    @Override
    public void execute() {
        if (this.currentRunState != null) {
            this.execute(this.currentRunState);
        } else {
            RuntimeException ex = new RuntimeException("Attempting to execute the controller without having setup the current RunState. One of the initialize methods must be called before calling this method.");
            msgCenter.error((Object)"DefaultController.execute: Error, attempting to execute the controller without having setup the current RunState. One of the initialize methods must be called before calling this method.", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public void batchInitialize() {
        this.currentBatchNumber = this.nextBatchNumber++;
        this.nextRunNumber = 1;
        this.prepare();
        this.runStateSetInBatch = true;
        this.batchInitialize(this.currentRunState, this.actionRegistry.getMasterContextId());
    }

    @Override
    public RunState runInitialize(Parameters params) {
        if (this.nextRunNumber == 1 && !this.prepare()) {
            this.runStateSetInBatch = false;
        }
        if (this.nextRunNumber != 1) {
            this.prepareForNextRun();
        }
        ++this.nextRunNumber;
        Object masterContextId = this.actionRegistry.getMasterContextId();
        this.loadRandomLoader();
        this.runInitialize(this.currentRunState, masterContextId, masterContextId, params);
        Iterable subIter = this.currentRunState.getMasterContext().getSubContexts();
        for (Context sub : subIter) {
            this.runInitialize(this.currentRunState, sub, params);
        }
        this.scheduleRunner.init();
        return this.currentRunState;
    }

    protected void loadRandomLoader() {
        Tree<ControllerAction> tree;
        Collection<ControllerAction> children;
        ControllerAction randomRoot = this.actionRegistry.findAction(this.actionRegistry.getMasterContextId(), "repast.controller.action.random_loaders");
        if (randomRoot == null) {
            randomRoot = new DefaultControllerAction();
            this.actionRegistry.addAction(this.actionRegistry.getMasterContextId(), null, randomRoot);
            this.actionRegistry.registerAction(this.actionRegistry.getMasterContextId(), "repast.controller.action.random_loaders", randomRoot);
        }
        if ((children = (tree = this.actionRegistry.getActionTree(this.actionRegistry.getMasterContextId())).getChildren(randomRoot)).size() == 0) {
            tree.addNode(randomRoot, new DefaultRandomStreamAction());
        }
    }

    @Override
    public Parameters runParameterSetters(Parameters params) {
        if (params == null) {
            params = new DefaultParameters();
        }
        for (ParameterSetter setter : this.actionRegistry.getParameterSetters()) {
            setter.next(params);
        }
        this.runEnvironmentBuilder.setParameters(params);
        if (this.nextRunNumber == 1 && this.currentRunEnvironment != null) {
            this.currentRunEnvironment.setParameters(params);
        }
        return params;
    }

    @Override
    public void runCleanup() {
        this.runCleanup(this.currentRunState, this.actionRegistry.getMasterContextId());
        if (!this.runStateSetInBatch) {
            this.cleanup();
        }
    }

    @Override
    public void batchCleanup() {
        this.batchCleanup(this.currentRunState, this.actionRegistry.getMasterContextId());
        this.cleanup();
    }

    protected boolean prepare() {
        if (this.currentRunState == null) {
            this.currentRunEnvironment = this.runEnvironmentBuilder.createRunEnvironment();
            this.currentRunState = RunState.init();
            this.currentRunState.setRunInfo(new RunInfo(this.actionRegistry.getName(), this.currentBatchNumber, this.nextRunNumber, this.currentRunEnvironment.isBatch()));
            this.currentRunState.getScheduleRegistry().setModelSchedule(this.currentRunEnvironment.getCurrentSchedule());
            this.currentRunState.getScheduleRegistry().setScheduleRunner(this.scheduleRunner);
            this.currentRunState.setControllerRegistry(this.actionRegistry);
            this.currentRunState.setRandomRegistry(new DefaultRandomRegistry());
            return true;
        }
        return false;
    }

    protected void prepareForNextRun() {
        if (this.currentRunState == null) {
            this.currentRunEnvironment = this.runEnvironmentBuilder.createRunEnvironment();
            this.currentRunState = RunState.init();
            this.currentRunState.setRunInfo(new RunInfo(this.actionRegistry.getName(), this.currentBatchNumber, this.nextRunNumber, this.currentRunEnvironment.isBatch()));
            this.currentRunState.getScheduleRegistry().setModelSchedule(this.currentRunEnvironment.getCurrentSchedule());
            this.currentRunState.getScheduleRegistry().setScheduleRunner(this.scheduleRunner);
            this.currentRunState.setControllerRegistry(this.actionRegistry);
            this.currentRunState.setRandomRegistry(new DefaultRandomRegistry());
        }
    }

    public void cleanup() {
        this.currentRunState = null;
    }

    @Override
    public int getNextRunNumber() {
        return this.nextRunNumber;
    }

    @Override
    public int getNextBatchNumber() {
        return this.nextBatchNumber;
    }

    @Override
    public RunState getCurrentRunState() {
        return this.currentRunState;
    }

    @Override
    public void setup() {
    }

    class DefaultActionComparator
    implements Comparator<ControllerAction> {
        Object contextID;

        public DefaultActionComparator(Object contextID) {
            this.contextID = contextID;
        }

        @Override
        public int compare(ControllerAction o1, ControllerAction o2) {
            ControllerAction dataInitRoot;
            ControllerAction dataSetRoot;
            ControllerAction dataLoaderRoot;
            ControllerAction randomRoot = DefaultController.this.actionRegistry.findAction(this.contextID, "repast.controller.action.random_loaders");
            if (randomRoot != null) {
                if (o1.equals(randomRoot)) {
                    return -1;
                }
                if (o2.equals(randomRoot)) {
                    return 1;
                }
            }
            if ((dataLoaderRoot = DefaultController.this.actionRegistry.findAction(this.contextID, "repast.controller.action.data_loaders")) != null) {
                if (o1.equals(dataLoaderRoot)) {
                    return -1;
                }
                if (o2.equals(dataLoaderRoot)) {
                    return 1;
                }
            }
            if ((dataSetRoot = DefaultController.this.actionRegistry.findAction(this.contextID, "repast.controller.action.data_sets")) != null) {
                if (o1.equals(dataSetRoot)) {
                    return -1;
                }
                if (o2.equals(dataSetRoot)) {
                    return 1;
                }
            }
            if ((dataInitRoot = DefaultController.this.actionRegistry.findAction(this.contextID, "repast.controller.action.data_init")) != null) {
                if (o1.equals(dataInitRoot)) {
                    return 1;
                }
                if (o2.equals(dataInitRoot)) {
                    return -1;
                }
            }
            return -1;
        }
    }
}

