/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.controller;

import java.util.HashSet;
import java.util.Set;

public abstract class ClassFilter {
    private static final ClassFilter ALWAYS_PASS = new AlwaysPassFilter();

    public abstract boolean apply(Class<?> var1);

    public static ClassFilter getNotEqualsFilter(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return ALWAYS_PASS;
        }
        if (classes.length == 1) {
            return new ClassFilter1(classes[0]);
        }
        if (classes.length == 2) {
            return new ClassFilter2(classes[0], classes[1]);
        }
        if (classes.length == 3) {
            return new ClassFilter3(classes[0], classes[1], classes[2]);
        }
        if (classes.length == 4) {
            return new ClassFilter4(classes[0], classes[1], classes[2], classes[3]);
        }
        HashSet set = new HashSet();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            set.add(clazz);
            ++n2;
        }
        return new ClassFilterN(set);
    }

    private static class AlwaysPassFilter
    extends ClassFilter {
        private AlwaysPassFilter() {
        }

        @Override
        public final boolean apply(Class<?> clazz) {
            return true;
        }
    }

    private static class ClassFilter1
    extends ClassFilter {
        private Class<?> c1;

        public ClassFilter1(Class<?> c1) {
            this.c1 = c1;
        }

        @Override
        public boolean apply(Class<?> clazz) {
            return !this.c1.equals(clazz);
        }
    }

    private static class ClassFilter2
    extends ClassFilter {
        private Class<?> c1;
        private Class<?> c2;

        public ClassFilter2(Class<?> c1, Class<?> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean apply(Class<?> clazz) {
            return !this.c1.equals(clazz) && !this.c2.equals(clazz);
        }
    }

    private static class ClassFilter3
    extends ClassFilter {
        private Class<?> c1;
        private Class<?> c2;
        private Class<?> c3;

        public ClassFilter3(Class<?> c1, Class<?> c2, Class<?> c3) {
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
        }

        @Override
        public boolean apply(Class<?> clazz) {
            return !this.c1.equals(clazz) && !this.c2.equals(clazz) && !this.c3.equals(clazz);
        }
    }

    private static class ClassFilter4
    extends ClassFilter {
        private Class<?> c1;
        private Class<?> c2;
        private Class<?> c3;
        private Class<?> c4;

        public ClassFilter4(Class<?> c1, Class<?> c2, Class<?> c3, Class<?> c4) {
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
        }

        @Override
        public boolean apply(Class<?> clazz) {
            return !this.c1.equals(clazz) && !this.c2.equals(clazz) && !this.c3.equals(clazz) && !this.c4.equals(clazz);
        }
    }

    private static class ClassFilterN
    extends ClassFilter {
        private Set<Class<?>> set;

        public ClassFilterN(Set<Class<?>> set) {
            this.set = set;
        }

        @Override
        public boolean apply(Class<?> clazz) {
            return !this.set.contains(clazz);
        }
    }
}

