/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.controller;

import org.apache.commons.collections15.Predicate;
import repast.simphony.context.Context;
import repast.simphony.engine.controller.ContextTraverser;
import repast.simphony.engine.controller.ControllerActionVisitor;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.graph.EngineGraphUtilities;
import repast.simphony.parameter.Parameters;
import simphony.util.messages.MessageCenter;

public abstract class AbstractControllerAction<T>
implements ControllerAction {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(AbstractControllerAction.class);

    @Override
    public void batchInitialize(RunState runState, Object contextId) {
    }

    @Override
    public void runInitialize(RunState runState, Object contextId, Parameters runParams) {
        this.runInitialize(runState, AbstractControllerAction.findContextInRunState(runState, contextId), runParams);
    }

    @Override
    public void runCleanup(RunState runState, Object contextId) {
        this.runCleanup(runState, AbstractControllerAction.findContextInRunState(runState, contextId));
    }

    @Override
    public void batchCleanup(RunState runState, Object contextId) {
    }

    public abstract void runInitialize(RunState var1, Context<? extends T> var2, Parameters var3);

    public abstract void runCleanup(RunState var1, Context<? extends T> var2);

    public static Context findContextInRunState(RunState runState, final Object contextId) {
        if (runState.getMasterContext() == null) {
            RuntimeException e = new RuntimeException("Error, the master context was not initialized properly and is null. A master context must beset.");
            msgCenter.error((Object)"AbstractControllerAction.findContextInRunState: Error, the master context was not initialized properly and is null. A master context must beset.", (Throwable)e, new Object[0]);
            throw e;
        }
        return EngineGraphUtilities.breadthFirstSearch(new Predicate<Context>(){

            public boolean evaluate(Context toCheck) {
                return toCheck.getId().equals(contextId);
            }
        }, new ContextTraverser(), runState.getMasterContext());
    }

    public void accept(ControllerActionVisitor visitor) {
        visitor.visit(this);
    }
}

