/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.physics;

import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.space.continuous.AbstractContinuousSpace;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.physics.DefaultPhysicsSpace;
import repast.simphony.space.projection.ProjectionEvent;

public class ContextPhysics<T>
extends DefaultPhysicsSpace<T>
implements ContextListener<T> {
    public ContextPhysics(String name, ContinuousAdder<T> adder, PointTranslator translator, double xdim, double ydim, double zdim) {
        super(name, adder, translator, xdim, ydim, zdim);
    }

    public ContextPhysics(String name, ContinuousAdder<T> adder, PointTranslator translator, double[] size, double[] origin) {
        super(name, adder, translator, size, origin);
    }

    @Override
    public void eventOccured(ContextEvent<T> evt) {
        T obj = evt.getTarget();
        ContextEvent.EventType type = evt.getType();
        if (type == ContextEvent.ADDED) {
            this.addFromContext(evt.getTarget());
        } else if (type == ContextEvent.REMOVED) {
            this.remove(obj);
        } else if (type == ContextEvent.EventType.PROJECTION_ADDED && evt.getProjection().equals(this)) {
            this.addAll(evt.getContext());
        } else if (type == ContextEvent.EventType.PROJECTION_REMOVED && evt.getProjection().equals(this)) {
            this.removeAll();
        }
    }

    protected void addFromContext(T t) {
        this.agentLocationMap.put(t, new AbstractContinuousSpace.PointHolder());
        this.adder.add(this, t);
        this.fireProjectionEvent(new ProjectionEvent(this, t, ProjectionEvent.OBJECT_ADDED));
    }

    protected void addAll(Context<T> context) {
        for (Object t : context) {
            this.addFromContext(t);
        }
    }
}

