/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.grid;

import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.space.grid.AbstractGrid;
import repast.simphony.space.grid.CellAccessor;
import repast.simphony.space.grid.DefaultGrid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.projection.ProjectionEvent;

public class ContextGrid<T>
extends DefaultGrid<T>
implements ContextListener<T> {
    public ContextGrid(String name, GridAdder<T> adder, GridPointTranslator translator, CellAccessor<T, Map<GridPoint, Object>> accessor, int ... size) {
        super(name, adder, translator, accessor, size);
    }

    public ContextGrid(String name, GridAdder<T> adder, GridPointTranslator translator, CellAccessor<T, Map<GridPoint, Object>> accessor, int[] size, int[] origin) {
        super(name, adder, translator, accessor, size, origin);
    }

    @Override
    public void eventOccured(ContextEvent<T> evt) {
        ContextEvent.EventType type = evt.getType();
        if (type == ContextEvent.ADDED) {
            this.addFromContext(evt.getTarget());
        } else if (type == ContextEvent.REMOVED) {
            this.remove(evt.getTarget());
        } else if (type == ContextEvent.EventType.PROJECTION_ADDED && evt.getProjection().equals(this)) {
            this.addAll(evt.getContext());
        } else if (type == ContextEvent.EventType.PROJECTION_REMOVED && evt.getProjection().equals(this)) {
            this.removeAll();
        }
    }

    protected void addFromContext(T t) {
        this.agentLocationMap.put(t, new AbstractGrid.PointHolder());
        this.adder.add(this, t);
        this.fireProjectionEvent(new ProjectionEvent(this, t, ProjectionEvent.OBJECT_ADDED));
    }

    protected void addAll(Context<T> context) {
        for (Object t : context) {
            this.addFromContext(t);
        }
    }
}

