/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.grid;

import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.space.grid.AbstractGrid;
import repast.simphony.space.grid.FastDenseSingleOccuGrid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.projection.ProjectionEvent;

public class ContextFastSingleGrid<T>
extends FastDenseSingleOccuGrid<T>
implements ContextListener<T> {
    public ContextFastSingleGrid(String name, GridAdder<T> adder, GridPointTranslator translator, int ... size) {
        super(name, adder, translator, size);
    }

    @Override
    public void eventOccured(ContextEvent<T> evt) {
        T obj = evt.getTarget();
        ContextEvent.EventType type = evt.getType();
        if (type == ContextEvent.ADDED) {
            this.addFromContext(evt.getTarget());
        } else if (type == ContextEvent.REMOVED) {
            this.remove(obj);
        } else if (type == ContextEvent.EventType.PROJECTION_ADDED && evt.getProjection() == this) {
            this.addAll(evt.getContext());
        } else if (type == ContextEvent.EventType.PROJECTION_REMOVED && evt.getProjection() == this) {
            this.removeAll();
        }
    }

    protected void addFromContext(T t) {
        this.agentLocationMap.put(t, new AbstractGrid.PointHolder());
        this.adder.add(this, t);
        this.fireProjectionEvent(new ProjectionEvent(this, t, ProjectionEvent.OBJECT_ADDED));
    }

    protected void addAll(Context<T> context) {
        for (Object t : context) {
            this.addFromContext(t);
        }
    }
}

