/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import edu.uci.ics.jung.algorithms.util.Indexer;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.collections15.BidiMap;
import repast.simphony.context.space.graph.AbstractGenerator;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;

public class WattsBetaSmallWorldGenerator<T>
extends AbstractGenerator<T> {
    private double beta;
    private int degree;
    private int numNodes;
    private boolean isSymmetrical;

    public WattsBetaSmallWorldGenerator(double beta, int degree, boolean symmetrical) {
        this.isSymmetrical = symmetrical;
        if (degree % 2 != 0) {
            msg.error((Object)"Error creating WattsBetaSmallWorldGenerator", (Throwable)new IllegalArgumentException("All nodes must have an even degree."), new Object[0]);
        }
        if (beta > 1.0 || beta < 0.0) {
            msg.error((Object)"Error creating WattsBetaSmallWorldGenerator", (Throwable)new IllegalArgumentException("Beta must be between 0 and 1."), new Object[0]);
        }
        this.beta = beta;
        this.degree = degree;
    }

    @Override
    public Network<T> createNetwork(Network<T> network) {
        this.numNodes = network.size();
        if (this.numNodes < 10) {
            msg.error((Object)"Error creating Watts beta small world network", (Throwable)new IllegalArgumentException("Number of nodes must be greater than 10"), new Object[0]);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object node : network.getNodes()) {
            set.add(node);
        }
        BidiMap map = Indexer.create(set);
        boolean isDirected = network.isDirected();
        int numKNeighbors = this.degree / 2;
        int i = 0;
        while (i < this.numNodes) {
            int n = 1;
            while (n <= numKNeighbors) {
                Object source = map.getKey((Object)i);
                int upI = this.upIndex(i, n);
                Object target = map.getKey((Object)upI);
                network.addEdge(source, target);
                if (isDirected && this.isSymmetrical) {
                    network.addEdge(target, source);
                }
                ++n;
            }
            ++i;
        }
        ArrayList<RepastEdge> edges = new ArrayList<RepastEdge>();
        for (RepastEdge repastEdge : network.getEdges()) {
            edges.add(repastEdge);
        }
        HashSet<RepastEdge<Object>> hashSet = new HashSet<RepastEdge<Object>>();
        for (RepastEdge edge : edges) {
            if (hashSet.contains(edge) || !(this.beta > RandomHelper.nextDouble())) continue;
            int rndIndex = RandomHelper.nextIntFromTo(0, this.numNodes - 1);
            Object randomNode = map.getKey((Object)rndIndex);
            Object source = edge.getSource();
            if (source.equals(randomNode) || network.isPredecessor(source, randomNode)) continue;
            network.removeEdge(edge);
            network.addEdge(source, randomNode);
            if (!isDirected || !this.isSymmetrical) continue;
            Object target = edge.getTarget();
            RepastEdge<Object> otherEdge = network.getEdge(target, source);
            network.removeEdge(otherEdge);
            hashSet.add(otherEdge);
            network.addEdge(randomNode, source);
        }
        return network;
    }

    private int upIndex(int currentIndex, int numSteps) {
        int value = currentIndex + numSteps;
        if (value > this.numNodes - 1) {
            return value % this.numNodes;
        }
        return value;
    }
}

