/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import edu.uci.ics.jung.algorithms.util.Indexer;
import java.util.HashSet;
import org.apache.commons.collections15.BidiMap;
import repast.simphony.context.space.graph.AbstractGenerator;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.graph.Network;

public class RandomDensityGenerator<T>
extends AbstractGenerator<T> {
    private double density;
    private boolean loops;
    private boolean isSymmetric;
    private BidiMap<T, Integer> map;

    public RandomDensityGenerator(double density, boolean allowSelfLoops, boolean symmetric) {
        this.loops = allowSelfLoops;
        this.isSymmetric = symmetric;
        this.density = density;
        if (density > 1.0 || density < 0.0) {
            msg.error((Object)"Error creating RandomDensityNetworkGenerator", (Throwable)new IllegalArgumentException("Density must be between 0 and 1."), new Object[0]);
        }
    }

    @Override
    public Network<T> createNetwork(Network<T> network) {
        boolean isDirected = network.isDirected();
        this.init(network);
        if (isDirected) {
            if (this.loops && this.isSymmetric) {
                return this.symmetricLoops(network);
            }
            if (!this.loops && !this.isSymmetric) {
                return this.nonSymmetricNoLoops(network);
            }
            if (this.loops) {
                return this.nonSymmetricLoops(network);
            }
            return this.symmetricNoLoops(network);
        }
        if (this.loops) {
            return this.nonSymmetricLoops(network);
        }
        return this.nonSymmetricNoLoops(network);
    }

    private Network<T> symmetricLoops(Network<T> network) {
        int i = 0;
        int n = network.size();
        while (i < n) {
            Object source = this.map.getKey((Object)i);
            int j = i;
            while (j < n) {
                if (RandomHelper.nextDouble() < this.density) {
                    Object target = this.map.getKey((Object)j);
                    network.addEdge(source, target);
                    network.addEdge(target, source);
                }
                ++j;
            }
            ++i;
        }
        return network;
    }

    private void init(Network<T> network) {
        HashSet<T> set = new HashSet<T>();
        for (T node : network.getNodes()) {
            set.add(node);
        }
        this.map = Indexer.create(set);
    }

    private Network<T> nonSymmetricNoLoops(Network<T> network) {
        int i = 0;
        int n = network.size();
        while (i < n) {
            Object source = this.map.getKey((Object)i);
            int j = i + 1;
            while (j < n) {
                if (RandomHelper.nextDouble() < this.density) {
                    Object target = this.map.getKey((Object)j);
                    network.addEdge(source, target);
                }
                ++j;
            }
            ++i;
        }
        return network;
    }

    private Network<T> nonSymmetricLoops(Network<T> network) {
        int i = 0;
        int n = network.size();
        while (i < n) {
            Object source = this.map.getKey((Object)i);
            int j = i;
            while (j < n) {
                if (RandomHelper.nextDouble() < this.density) {
                    Object target = this.map.getKey((Object)j);
                    network.addEdge(source, target);
                }
                ++j;
            }
            ++i;
        }
        return network;
    }

    private Network<T> symmetricNoLoops(Network<T> network) {
        int i = 0;
        int n = network.size();
        while (i < n) {
            Object source = this.map.getKey((Object)i);
            int j = i + 1;
            while (j < n) {
                if (RandomHelper.nextDouble() < this.density) {
                    Object target = this.map.getKey((Object)j);
                    network.addEdge(source, target);
                    network.addEdge(target, source);
                }
                ++j;
            }
            ++i;
        }
        return network;
    }
}

