/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import repast.simphony.context.Context;
import repast.simphony.context.space.graph.ContextJungNetwork;
import repast.simphony.context.space.graph.NetworkFileFormat;
import repast.simphony.context.space.graph.NetworkGenerator;
import repast.simphony.context.space.graph.NodeCreator;
import repast.simphony.space.graph.DefaultEdgeCreator;
import repast.simphony.space.graph.DirectedJungNetwork;
import repast.simphony.space.graph.EdgeCreator;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.UndirectedJungNetwork;

public class NetworkBuilder<T> {
    private Context<T> context;
    private boolean isDirected;
    private String name;
    private EdgeCreator edgeCreator = new DefaultEdgeCreator();
    private NetworkGenerator<T> loader;
    private NetworkGenerator<T> generator;

    public NetworkBuilder(String networkName, Context<T> context, boolean isDirected) {
        this.name = networkName;
        this.context = context;
        this.isDirected = isDirected;
    }

    public NetworkBuilder setGenerator(NetworkGenerator<T> generator) {
        this.generator = generator;
        return this;
    }

    public NetworkBuilder setEdgeCreator(EdgeCreator edgeCreator) {
        this.edgeCreator = edgeCreator;
        return this;
    }

    public NetworkBuilder load(String fileName, NetworkFileFormat format, NodeCreator nodeCreator) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
        this.loader = format.createLoader(this.context, in, nodeCreator, 0);
        return this;
    }

    public NetworkBuilder load(String fileName, NetworkFileFormat format, NodeCreator nodeCreator, int matrixIndex) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
        this.loader = format.createLoader(this.context, in, nodeCreator, matrixIndex);
        return this;
    }

    public Network<T> buildNetwork() {
        Network net = this.isDirected ? new ContextJungNetwork(new DirectedJungNetwork(this.name, this.edgeCreator), this.context) : new ContextJungNetwork(new UndirectedJungNetwork(this.name, this.edgeCreator), this.context);
        this.context.addProjection(net);
        if (this.loader != null) {
            net = this.loader.createNetwork(net);
        }
        if (this.generator != null) {
            net = this.generator.createNetwork(net);
        }
        return net;
    }
}

