/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.space.graph.AdjacencyMatrix;
import repast.simphony.context.space.graph.DefaultNodeCreator;
import repast.simphony.context.space.graph.NetworkGenerator;
import repast.simphony.context.space.graph.NetworkMatrixReader;
import repast.simphony.context.space.graph.NodeCreator;
import repast.simphony.space.graph.Network;
import simphony.util.messages.MessageCenter;

public abstract class MatrixNetworkLoader<T>
implements NetworkGenerator {
    private static MessageCenter msg = MessageCenter.getMessageCenter(MatrixNetworkLoader.class);
    private Context context;
    private InputStream stream;
    private NodeCreator<T> creator;
    private int matrixIndex;

    public MatrixNetworkLoader(Context context, InputStream stream, Class agentClass, int matrixIndex) {
        this(context, stream, new DefaultNodeCreator(agentClass), matrixIndex);
    }

    public MatrixNetworkLoader(Context context, InputStream stream, NodeCreator<T> nodeCreator, int matrixIndex) {
        this.context = context;
        this.stream = stream;
        this.creator = nodeCreator;
        this.matrixIndex = matrixIndex;
    }

    protected abstract NetworkMatrixReader getMatrixReader(InputStream var1) throws IOException;

    public Network createNetwork(Network network) {
        try (NetworkMatrixReader reader = null;){
            try {
                reader = this.getMatrixReader(this.stream);
                List<AdjacencyMatrix> matrices = reader.getMatrices();
                AdjacencyMatrix matrix = matrices.get(this.matrixIndex);
                Map<Integer, T> nodeMap = this.createNodes(matrix);
                int i = 0;
                while (i < matrix.rows()) {
                    T source = nodeMap.get(i);
                    int j = 0;
                    while (j < matrix.rows()) {
                        double val = matrix.get(i, j);
                        if (val != 0.0) {
                            T target = nodeMap.get(j);
                            network.addEdge(source, target, val);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                msg.error((Object)"Error while reading network data", (Throwable)ex, new Object[0]);
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return network;
    }

    private Map<Integer, T> createNodes(AdjacencyMatrix matrix) {
        List<String> nodeLabels = matrix.getLabels();
        if (nodeLabels.size() > 0 && nodeLabels.size() != matrix.rows()) {
            msg.error((Object)"Number of matrix labels not equal to number of matrix rows", (Throwable)new IllegalArgumentException(), new Object[0]);
            return null;
        }
        HashMap<Integer, T> map = new HashMap<Integer, T>();
        if (nodeLabels.size() > 0) {
            int i = 0;
            for (String label : nodeLabels) {
                T node = this.creator.createNode(label);
                this.context.add(node);
                map.put(i++, node);
            }
        } else {
            int i = 0;
            while (i < matrix.rows()) {
                T node = this.creator.createNode(String.valueOf(i));
                this.context.add(node);
                map.put(i, node);
                ++i;
            }
        }
        return map;
    }
}

