/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import edu.uci.ics.jung.algorithms.util.Indexer;
import java.util.HashSet;
import org.apache.commons.collections15.BidiMap;
import repast.simphony.context.space.graph.AbstractGenerator;
import repast.simphony.space.graph.Network;

public class Lattice2DGenerator<T>
extends AbstractGenerator<T> {
    private boolean isToroidal;
    private int latticeSize;

    public Lattice2DGenerator(boolean isToroidal) {
        this.isToroidal = isToroidal;
    }

    @Override
    public Network<T> createNetwork(Network<T> network) {
        this.latticeSize = (int)Math.floor(Math.sqrt(network.size()));
        HashSet<T> set = new HashSet<T>();
        for (T node : network.getNodes()) {
            set.add(node);
        }
        int currentLatticeRow = 0;
        int currentLatticeColumn = 0;
        int upIndex = 0;
        int downIndex = 0;
        int leftIndex = 0;
        int rightIndex = 0;
        BidiMap map = Indexer.create(set);
        int numNodes = network.size();
        boolean isDirected = network.isDirected();
        int i = 0;
        while (i < numNodes) {
            Object target;
            Object source;
            currentLatticeRow = i / this.latticeSize;
            currentLatticeColumn = i % this.latticeSize;
            upIndex = this.upIndex(currentLatticeRow, currentLatticeColumn);
            leftIndex = this.leftIndex(currentLatticeRow, currentLatticeColumn);
            downIndex = this.downIndex(currentLatticeRow, currentLatticeColumn);
            rightIndex = this.rightIndex(currentLatticeRow, currentLatticeColumn);
            if (currentLatticeRow != 0 || currentLatticeRow == 0 && this.isToroidal) {
                source = map.getKey((Object)i);
                target = map.getKey((Object)upIndex);
                if (isDirected) {
                    network.addEdge(source, target);
                } else if (!network.isAdjacent(source, target)) {
                    network.addEdge(source, target);
                }
            }
            if (currentLatticeColumn != 0 || currentLatticeColumn == 0 && this.isToroidal) {
                source = map.getKey((Object)i);
                target = map.getKey((Object)leftIndex);
                if (isDirected) {
                    network.addEdge(source, target);
                } else if (!network.isAdjacent(source, target)) {
                    network.addEdge(source, target);
                }
            }
            if (currentLatticeRow != this.latticeSize - 1 || currentLatticeRow == this.latticeSize - 1 && this.isToroidal) {
                source = map.getKey((Object)i);
                target = map.getKey((Object)downIndex);
                if (isDirected) {
                    network.addEdge(source, target);
                } else if (!network.isAdjacent(source, target)) {
                    network.addEdge(source, target);
                }
            }
            if (currentLatticeColumn != this.latticeSize - 1 || currentLatticeColumn == this.latticeSize - 1 && this.isToroidal) {
                source = map.getKey((Object)i);
                target = map.getKey((Object)rightIndex);
                if (isDirected) {
                    network.addEdge(source, target);
                } else if (!network.isAdjacent(source, target)) {
                    network.addEdge(source, target);
                }
            }
            ++i;
        }
        return network;
    }

    protected int upIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeRow == 0) {
            return this.latticeSize * (this.latticeSize - 1) + currentLatticeColumn;
        }
        return (currentLatticeRow - 1) * this.latticeSize + currentLatticeColumn;
    }

    protected int downIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeRow == this.latticeSize - 1) {
            return currentLatticeColumn;
        }
        return (currentLatticeRow + 1) * this.latticeSize + currentLatticeColumn;
    }

    protected int leftIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeColumn == 0) {
            return currentLatticeRow * this.latticeSize + this.latticeSize - 1;
        }
        return currentLatticeRow * this.latticeSize + currentLatticeColumn - 1;
    }

    protected int rightIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeColumn == this.latticeSize - 1) {
            return currentLatticeRow * this.latticeSize;
        }
        return currentLatticeRow * this.latticeSize + currentLatticeColumn + 1;
    }
}

