/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import edu.uci.ics.jung.algorithms.util.Indexer;
import java.util.HashSet;
import org.apache.commons.collections15.BidiMap;
import repast.simphony.context.space.graph.AbstractGenerator;
import repast.simphony.space.graph.Network;

public class Lattice1DGenerator<T>
extends AbstractGenerator<T> {
    private boolean isToroidal;
    private boolean isSymmetrical;
    private int numNodes;

    public Lattice1DGenerator(boolean toroidal, boolean symmetrical) {
        this.isToroidal = toroidal;
        this.isSymmetrical = symmetrical;
    }

    @Override
    public Network<T> createNetwork(Network<T> network) {
        this.numNodes = network.size();
        HashSet<T> set = new HashSet<T>();
        for (T node : network.getNodes()) {
            set.add(node);
        }
        BidiMap map = Indexer.create(set);
        boolean isDirected = network.isDirected();
        int i = 0;
        while (i < this.numNodes) {
            int downI;
            Object target;
            Object source = map.getKey((Object)i);
            int upI = this.upIndex(i);
            if (upI != -1) {
                target = map.getKey((Object)upI);
                if (isDirected) {
                    network.addEdge(source, target);
                } else if (!network.isAdjacent(source, target)) {
                    network.addEdge(source, target);
                }
            }
            if (isDirected && this.isSymmetrical && (downI = this.downIndex(i)) != -1) {
                target = map.getKey((Object)downI);
                if (isDirected) {
                    network.addEdge(source, target);
                } else if (!network.isAdjacent(source, target)) {
                    network.addEdge(source, target);
                }
            }
            ++i;
        }
        return network;
    }

    protected int downIndex(int currentIndex) {
        if (currentIndex == 0) {
            if (this.isToroidal) {
                return this.numNodes - 1;
            }
            return -1;
        }
        return currentIndex - 1;
    }

    private int upIndex(int currentIndex) {
        if (currentIndex == this.numNodes - 1) {
            if (this.isToroidal) {
                return 0;
            }
            return -1;
        }
        return currentIndex + 1;
    }
}

