/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import repast.simphony.context.space.graph.AdjacencyDoubleMatrix;
import repast.simphony.context.space.graph.AdjacencyMatrix;
import repast.simphony.context.space.graph.NetworkMatrixReader;

public class ExcelMatrixReader
implements NetworkMatrixReader {
    private HSSFWorkbook workbook = null;

    public ExcelMatrixReader(InputStream in) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        this.workbook = new HSSFWorkbook(fs);
        in.close();
    }

    private AdjacencyDoubleMatrix getLabeledMatrix(HSSFSheet sheet) throws IOException {
        AdjacencyDoubleMatrix m = null;
        ArrayList<String> labels = new ArrayList<String>();
        HSSFRow row = sheet.getRow(0);
        if (row != null) {
            Iterator ci = row.cellIterator();
            while (ci.hasNext()) {
                HSSFCell cell = (HSSFCell)ci.next();
                String label = cell.getRichStringCellValue().getString();
                if (cell.getCellNum() == 0 && !label.equals("")) {
                    throw new IOException("Badly formatted Excel matrix file: labels must start at 1, 2");
                }
                if (label.length() <= 0) continue;
                labels.add(label);
            }
        }
        if (labels.size() > 0) {
            m = new AdjacencyDoubleMatrix(labels);
        }
        return m;
    }

    private AdjacencyDoubleMatrix getNonLabeledMatrix(HSSFSheet sheet) {
        int height = sheet.getPhysicalNumberOfRows();
        return new AdjacencyDoubleMatrix(height, height);
    }

    private AdjacencyMatrix getMatrix(String sheetName) throws IOException {
        HSSFSheet sheet = this.workbook.getSheet(sheetName);
        AdjacencyDoubleMatrix matrix = this.getLabeledMatrix(sheet);
        int numRows = sheet.getPhysicalNumberOfRows();
        boolean hasLabels = true;
        if (matrix == null) {
            matrix = this.getNonLabeledMatrix(sheet);
            hasLabels = false;
            ++numRows;
        }
        int i = 1;
        while (i < numRows) {
            HSSFRow row = sheet.getRow(i);
            Iterator ci = row.cellIterator();
            if (hasLabels && ci.hasNext()) {
                ci.next();
            }
            while (ci.hasNext()) {
                HSSFCell cell = (HSSFCell)ci.next();
                Short pos = cell.getCellNum();
                matrix.set(i - 1, pos.intValue() - 1, cell.getNumericCellValue());
            }
            ++i;
        }
        if (!sheetName.startsWith("Sheet")) {
            matrix.setMatrixLabel(sheetName);
        }
        return matrix;
    }

    @Override
    public List<AdjacencyMatrix> getMatrices() throws IOException {
        ArrayList<AdjacencyMatrix> list = new ArrayList<AdjacencyMatrix>();
        int numSheets = this.workbook.getNumberOfSheets();
        int i = 0;
        while (i < numSheets) {
            list.add(this.getMatrix(this.workbook.getSheetName(i)));
            ++i;
        }
        return list;
    }

    @Override
    public void close() {
        this.workbook = null;
    }
}

