/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import repast.simphony.context.space.graph.NodeCreator;
import simphony.util.messages.MessageCenter;

public class DefaultNodeCreator
implements NodeCreator {
    private static MessageCenter msg = MessageCenter.getMessageCenter(DefaultNodeCreator.class);
    private Class nodeClass;
    private Constructor constructor;

    public DefaultNodeCreator(Class nodeClass) {
        this.nodeClass = nodeClass;
        try {
            this.constructor = nodeClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Object createNode(String label) {
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(label);
            }
            return this.nodeClass.newInstance();
        }
        catch (IllegalAccessException e) {
            msg.error((Object)"Error while creating agent / node", (Throwable)e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            msg.error((Object)"Error while creating agent / node", (Throwable)e, new Object[0]);
        }
        catch (InstantiationException e) {
            msg.error((Object)"Error while creating agent / node", (Throwable)e, new Object[0]);
        }
        return null;
    }
}

