/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import repast.simphony.context.space.graph.AdjacencyDoubleMatrix;
import repast.simphony.context.space.graph.AdjacencyMatrix;
import repast.simphony.context.space.graph.NetworkMatrixReader;

public class DLMatrixReader
implements NetworkMatrixReader {
    private BufferedReader reader;
    private long numNodes = -1L;
    private int numMatrices = 1;
    private List<String> labels;
    private List<String> matrixLabels;
    private boolean hasMatrixLabels = false;

    public DLMatrixReader(String filename) throws IOException {
        this.reader = new BufferedReader(new FileReader(filename));
    }

    public DLMatrixReader(InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    public List<AdjacencyMatrix> getMatrices() throws IOException {
        this.readHeader();
        this.readLabels();
        if (this.hasMatrixLabels) {
            this.readMatrixLabels();
        }
        ArrayList<AdjacencyMatrix> matrices = new ArrayList<AdjacencyMatrix>();
        int i = 0;
        while (i < this.numMatrices) {
            AdjacencyDoubleMatrix m = this.labels.size() > 0 ? new AdjacencyDoubleMatrix(this.labels) : new AdjacencyDoubleMatrix((int)this.numNodes, (int)this.numNodes);
            if (this.hasMatrixLabels) {
                m.setMatrixLabel(this.matrixLabels.get(i));
            }
            matrices.add(this.loadData(m));
            ++i;
        }
        return matrices;
    }

    private void readHeader() throws IOException {
        String header;
        while ((header = this.reader.readLine()) != null) {
            if ((header = header.trim()).length() > 0) break;
        }
        if (header == null) {
            throw new IOException("File is not a valid dl file");
        }
        if (!header.startsWith("dl")) {
            throw new IOException("File is not a valid dl file");
        }
        this.parseForNumNodesMatrices(header);
    }

    private void parseForNumNodesMatrices(String header) throws IOException {
        StringTokenizer tok = new StringTokenizer(header, " ");
        tok.nextToken();
        this.numNodes = this.parseForValue("n", tok, 1);
        if (tok.hasMoreTokens()) {
            this.numMatrices = (int)this.parseForValue("nm", tok, 2);
        }
        if (this.numNodes < 0L) {
            throw new IOException("File is not a valid dl file");
        }
    }

    private long parseForValue(String lookFor, StringTokenizer tok, int length) throws IOException {
        if (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!token.startsWith(lookFor)) {
                throw new IOException("File is not a valid dl file");
            }
            if (token.length() > length) {
                char[] c = token.toCharArray();
                if (c[length] == '=' || c[length] == ',') {
                    if (c.length > 1) {
                        try {
                            if (token.endsWith(",")) {
                                token = token.substring(0, token.length() - 1);
                            }
                            return Long.parseLong(token.substring(length + 1, token.length()));
                        }
                        catch (NumberFormatException ex) {
                            throw new IOException("File is not a valid dl file");
                        }
                    }
                    throw new IOException("File is not a valid dl file");
                }
                throw new IOException("File is not a valid dl file");
            }
            if (tok.hasMoreTokens()) {
                token = tok.nextToken();
                if (token.startsWith("=")) {
                    if (token.length() > 1) {
                        try {
                            if (token.endsWith(",")) {
                                token = token.substring(0, token.length() - 1);
                            }
                            return Long.parseLong(token.substring(1, token.length()));
                        }
                        catch (NumberFormatException ex) {
                            throw new IOException("File is not a valid dl file");
                        }
                    }
                    if (tok.hasMoreTokens()) {
                        try {
                            token = tok.nextToken();
                            if (token.endsWith(",")) {
                                token = token.substring(0, token.length() - 1);
                            }
                            return Long.parseLong(token);
                        }
                        catch (NumberFormatException ex) {
                            throw new IOException("File is not a valid dl file");
                        }
                    }
                    throw new IOException("File is not a valid dl file");
                }
                try {
                    if (token.endsWith(",")) {
                        token = token.substring(0, token.length() - 1);
                    }
                    return Long.parseLong(token);
                }
                catch (NumberFormatException ex) {
                    throw new IOException("File is not a valid dl file");
                }
            }
            throw new IOException("File is not a valid dl file");
        }
        throw new IOException("File is not a valid dl file");
    }

    private void parseLineForLabel(String line, List<String> labelArray) throws IOException {
        char[] array = line.trim().toCharArray();
        int labelStart = -1;
        boolean labelStarted = false;
        int i = 0;
        while (i < array.length) {
            if (array[i] == '\"') {
                labelStart = ++i;
                while (i < array.length) {
                    if (array[i] == '\"') {
                        labelArray.add(line.substring(labelStart, i));
                        labelStart = -1;
                        break;
                    }
                    ++i;
                }
                if (labelStart != -1) {
                    throw new IOException("File is not valid dl file");
                }
            } else if (array[i] == ' ' || array[i] == ',' || array[i] == '\r' || array[i] == '\n') {
                if (labelStarted) {
                    labelArray.add(line.substring(labelStart, i));
                    labelStarted = false;
                    labelStart = -1;
                }
            } else if (!labelStarted && array[i] != '\"') {
                System.out.println(array[i]);
                labelStart = i;
                labelStarted = true;
            }
            ++i;
        }
        if (labelStart != -1) {
            throw new IOException("File not a valid dl file");
        }
    }

    private void readMatrixLabels() throws IOException {
        String line;
        this.matrixLabels = new ArrayList<String>();
        while ((line = this.reader.readLine()) != null) {
            if (line.equals("data:")) break;
            this.parseLineForLabel(line, this.matrixLabels);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readLabels() throws IOException {
        this.labels = new ArrayList<String>();
        line = this.reader.readLine();
        if (line.equals("labels:")) ** GOTO lbl13
        this.labels = new ArrayList<String>();
        if (line.equals("matrix labels:")) {
            this.hasMatrixLabels = true;
        }
        return;
        while (!line.equals("data:")) {
            if (line.equals("matrix labels:")) {
                this.hasMatrixLabels = true;
                break;
            }
            this.parseLineForLabel(line, this.labels);
lbl13:
            // 2 sources

            if ((line = this.reader.readLine()) != null) continue;
        }
    }

    private AdjacencyMatrix loadData(AdjacencyDoubleMatrix matrix) throws IOException {
        String line = this.reader.readLine();
        while (line.trim().length() == 0) {
            line = this.reader.readLine();
        }
        int i = 0;
        while ((long)i < this.numNodes) {
            StringTokenizer t = new StringTokenizer(line, " ");
            int j = 0;
            while (t.hasMoreTokens()) {
                String val = t.nextToken();
                matrix.set(i, j, Double.parseDouble(val));
                ++j;
            }
            line = this.reader.readLine();
            ++i;
        }
        return matrix;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

