/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context.space.graph;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import org.apache.log4j.Level;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.space.graph.EdgeCreator;
import repast.simphony.space.graph.JungNetwork;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.space.projection.ProjectionPredicate;
import simphony.util.messages.MessageCenter;

public class ContextJungNetwork<T>
implements Network<T>,
ContextListener<T> {
    JungNetwork<T> network;
    Context<T> context;
    private int hashCode;

    public ContextJungNetwork(JungNetwork<T> net, Context<T> context) {
        this.network = net;
        this.hashCode = 17;
        this.hashCode = 37 * this.hashCode + this.network.hashCode();
        this.hashCode = 37 * this.hashCode + context.hashCode();
        this.context = context;
    }

    @Override
    public void eventOccured(ContextEvent<T> ev) {
        ContextEvent.EventType type = ev.getType();
        if (type == ContextEvent.EventType.AGENT_ADDED) {
            this.addVertex(ev.getTarget());
        } else if (type == ContextEvent.EventType.AGENT_REMOVED) {
            this.removeVertex(ev.getTarget());
        } else if (type == ContextEvent.EventType.PROJECTION_ADDED && ev.getProjection().equals(this)) {
            this.context = ev.getContext();
            this.addAll();
        } else if (type == ContextEvent.EventType.PROJECTION_REMOVED && ev.getProjection().equals(this)) {
            this.removeAll();
            this.context = null;
        }
    }

    protected void addAll() {
        for (Object item : this.context) {
            this.addVertex(item);
        }
    }

    protected void removeAll() {
        for (Object item : this.context) {
            this.removeVertex(item);
        }
    }

    @Override
    public EdgeCreator<? extends RepastEdge<T>, T> getEdgeCreator() {
        return this.network.getEdgeCreator();
    }

    @Override
    public RepastEdge<T> addEdge(RepastEdge<T> edge) {
        if (!this.context.contains(edge.getSource()) || !this.context.contains(edge.getTarget())) {
            String message = "Source and/or target of the network have not been added to the context.";
            MessageCenter.getMessageCenter(ContextJungNetwork.class).fireMessageEvent(Level.ERROR, (Object)message, (Throwable)new NullPointerException(message), new Object[0]);
        }
        return this.network.addEdge(edge);
    }

    @Override
    public RepastEdge<T> addEdge(T source, T target, double weight) {
        return this.network.addEdge(source, target, weight);
    }

    @Override
    public RepastEdge<T> addEdge(T source, T target) {
        return this.network.addEdge(source, target);
    }

    @Override
    public void addProjectionListener(ProjectionListener listener) {
        this.network.addProjectionListener(listener);
    }

    public void addVertex(T vertex) {
        this.network.addVertex(vertex);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContextJungNetwork) {
            ContextJungNetwork other = (ContextJungNetwork)obj;
            return this.network.equals(other.network) && (this.context == null ? other.context == null : other.context != null && this.context.equals(other.context));
        }
        return false;
    }

    @Override
    public boolean evaluate(ProjectionPredicate predicate) {
        return this.network.evaluate(predicate);
    }

    @Override
    public Iterable<T> getAdjacent(T agent) {
        return this.network.getAdjacent(agent);
    }

    @Override
    public int getDegree() {
        return this.network.getDegree();
    }

    @Override
    public int getDegree(T agent) {
        return this.network.getDegree(agent);
    }

    @Override
    public RepastEdge<T> getEdge(T source, T target) {
        return this.network.getEdge(source, target);
    }

    @Override
    public Iterable<RepastEdge<T>> getEdges() {
        return this.network.getEdges();
    }

    @Override
    public Iterable<RepastEdge<T>> getEdges(T agent) {
        return this.network.getEdges(agent);
    }

    public Graph<T, RepastEdge<T>> getGraph() {
        return this.network.getGraph();
    }

    @Override
    public int getInDegree(T agent) {
        return this.network.getInDegree(agent);
    }

    @Override
    public Iterable<RepastEdge<T>> getInEdges(T agent) {
        return this.network.getInEdges(agent);
    }

    @Override
    public String getName() {
        return this.network.getName();
    }

    @Override
    public Iterable<T> getNodes() {
        return this.network.getNodes();
    }

    @Override
    public int getOutDegree(T agent) {
        return this.network.getOutDegree(agent);
    }

    @Override
    public Iterable<RepastEdge<T>> getOutEdges(T agent) {
        return this.network.getOutEdges(agent);
    }

    @Override
    public Iterable<T> getPredecessors(T agent) {
        return this.network.getPredecessors(agent);
    }

    @Override
    public Collection<ProjectionListener> getProjectionListeners() {
        return this.network.getProjectionListeners();
    }

    @Override
    public T getRandomAdjacent(T agent) {
        return this.network.getRandomAdjacent(agent);
    }

    @Override
    public T getRandomPredecessor(T agent) {
        return this.network.getRandomPredecessor(agent);
    }

    @Override
    public T getRandomSuccessor(T agent) {
        return this.network.getRandomSuccessor(agent);
    }

    @Override
    public Iterable<T> getSuccessors(T agent) {
        return this.network.getSuccessors(agent);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isAdjacent(T first, T second) {
        return this.network.isAdjacent(first, second);
    }

    @Override
    public boolean isDirected() {
        return this.network.isDirected();
    }

    @Override
    public boolean isPredecessor(T first, T second) {
        return this.network.isPredecessor(first, second);
    }

    @Override
    public boolean isSuccessor(T first, T second) {
        return this.network.isSuccessor(first, second);
    }

    @Override
    public int numEdges() {
        return this.network.numEdges();
    }

    @Override
    public void removeEdge(RepastEdge<T> edge) {
        this.network.removeEdge(edge);
    }

    @Override
    public boolean containsEdge(RepastEdge<T> edge) {
        return this.network.containsEdge(edge);
    }

    @Override
    public boolean removeProjectionListener(ProjectionListener listener) {
        return this.network.removeProjectionListener(listener);
    }

    public void removeVertex(T vertex) {
        this.network.removeVertex(vertex);
    }

    public void setGraph(Graph<T, RepastEdge<T>> graph) {
        this.network.setGraph(graph);
    }

    @Override
    public int size() {
        return this.network.size();
    }

    public String toString() {
        return this.network.toString();
    }

    @Override
    public void removeEdges() {
        this.network.removeEdges();
    }
}

