/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.iterators.IteratorChain;
import org.apache.commons.collections15.iterators.SingletonIterator;
import repast.simphony.context.AbstractContext;
import repast.simphony.context.Context;
import repast.simphony.context.ContextIndexedIterable;
import repast.simphony.context.ContextIterable;
import repast.simphony.random.RandomHelper;
import repast.simphony.util.collections.CompositeIndexedIterable;
import repast.simphony.util.collections.IndexedIterable;
import repast.simphony.util.collections.IterableAdaptor;

public class SmallDefaultContext<T>
extends AbstractContext<T> {
    protected Map<Class, List<T>> objectMap = new LinkedHashMap<Class, List<T>>();
    private int size;
    protected IndexedIterable allObjs = null;

    public SmallDefaultContext() {
    }

    public SmallDefaultContext(Object id) {
        this(id, id);
    }

    public SmallDefaultContext(Object name, Object typeID) {
        this.setId(name);
        this.setTypeID(typeID);
    }

    @Override
    protected boolean containsInternal(Object o) {
        for (List<T> list : this.objectMap.values()) {
            if (!list.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Iterator<T> iteratorInternal() {
        IteratorChain chain = new IteratorChain();
        for (List<T> list : this.objectMap.values()) {
            chain.addIterator(list.iterator());
        }
        return chain;
    }

    @Override
    protected int sizeInternal() {
        return this.size;
    }

    @Override
    protected boolean addInternal(T o) {
        this.allObjs = null;
        Class<?> clazz = o.getClass();
        List<T> list = this.objectMap.get(clazz);
        if (list == null) {
            list = new ArrayList<T>();
            this.objectMap.put(clazz, list);
        }
        list.add(o);
        ++this.size;
        return true;
    }

    @Override
    protected boolean removeInternal(Object obj) {
        this.allObjs = null;
        Class<?> clazz = obj.getClass();
        List<T> list = this.objectMap.get(clazz);
        if (list == null) {
            return false;
        }
        boolean val = list.remove(obj);
        if (list.size() == 0) {
            this.objectMap.remove(clazz);
        }
        if (val) {
            --this.size;
        }
        return val;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet set = null;
        set = c instanceof Set ? (HashSet)c : new HashSet(c);
        ArrayList toRemove = new ArrayList();
        for (Object obj : this) {
            if (set.contains(obj)) continue;
            toRemove.add(obj);
        }
        this.removeAll(toRemove);
        return toRemove.size() > 0;
    }

    @Override
    public IndexedIterable<T> getObjects(Class<?> clazz) {
        CompositeIndexedIterable iter = new CompositeIndexedIterable();
        for (Map.Entry<Class, List<T>> entry : this.objectMap.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            iter.addIndexedIterable(new ContextIndexedIterable<T>(this, entry.getValue()));
        }
        if (this.subContexts.size() == 0) {
            return iter;
        }
        for (Context context : this.subContexts.values()) {
            IndexedIterable child = context.getObjects(clazz);
            if (child.size() <= 0) continue;
            iter.addIndexedIterable(child);
        }
        return iter;
    }

    @Override
    public Iterable<T> getRandomObjects(Class<? extends T> clazz, long count) {
        IndexedIterable<T> iter = this.getObjects(clazz);
        if (iter.size() == 0) {
            return Collections.emptyList();
        }
        if (count == 1L) {
            T obj = iter.get(RandomHelper.nextIntFromTo(0, iter.size() - 1));
            if (obj == null) {
                return Collections.emptyList();
            }
            return new IterableAdaptor(new SingletonIterator(obj, false));
        }
        return new ContextIterable<T>(iter, count, this);
    }

    @Override
    public T getRandomObject() {
        if (this.allObjs == null) {
            this.allObjs = this.getObjects(Object.class);
        }
        return this.allObjs.get(RandomHelper.nextIntFromTo(0, this.allObjs.size() - 1));
    }
}

