/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.context;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.PredicateUtils;
import org.apache.commons.collections15.iterators.FilterIterator;
import org.apache.commons.collections15.iterators.IteratorChain;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.space.projection.Projection;
import repast.simphony.util.collections.IterableAdaptor;
import repast.simphony.valueLayer.ValueLayer;
import simphony.util.messages.MessageCenter;

public abstract class AbstractContext<T>
extends AbstractCollection<T>
implements Context<T>,
ContextListener {
    private Object id;
    private Object typeID;
    private static int idNo = 0;
    private List<ContextListener<T>> listeners = new CopyOnWriteArrayList<ContextListener<T>>();
    protected Map<Object, Context<? extends T>> subContexts = new LinkedHashMap<Object, Context<? extends T>>();
    private Map<String, Projection<?>> projectionMap = new HashMap();
    private Map<String, ValueLayer> valueLayerMap = new HashMap<String, ValueLayer>();
    private Set<Class> agentClasses = new LinkedHashSet<Class>();

    public AbstractContext() {
        this.id = "__Synthetic_Context__" + idNo;
        this.typeID = "__Synthetic_Context__Type__" + idNo;
        ++idNo;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public Object getTypeID() {
        return this.typeID;
    }

    @Override
    public void setTypeID(Object id) {
        this.typeID = id;
    }

    @Override
    public void addContextListener(ContextListener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public Collection<ContextListener<T>> getContextListeners() {
        return this.listeners;
    }

    @Override
    public Iterable<T> query(Predicate query) {
        return new IterableAdaptor(new FilterIterator(this.iterator(), query));
    }

    @Override
    public void removeContextListener(ContextListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public final boolean add(T o) {
        if (this.addInternal(o)) {
            this.agentClasses.add(o.getClass());
            this.fireAddContextEvent(o);
            return true;
        }
        return false;
    }

    protected void fireAddContextEvent(T o) {
        this.fireContextEvent(new ContextEvent<T>(ContextEvent.EventType.AGENT_ADDED, this, o));
    }

    protected abstract boolean addInternal(T var1);

    protected abstract boolean containsInternal(Object var1);

    @Override
    public boolean contains(Object o) {
        if (this.containsInternal(o)) {
            return true;
        }
        for (Context<T> sub : this.getSubContexts()) {
            if (!sub.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        IteratorChain iter = new IteratorChain();
        iter.addIterator(this.iteratorInternal());
        for (Context<T> sub : this.getSubContexts()) {
            iter.addIterator(sub.iterator());
        }
        return iter;
    }

    protected abstract Iterator<T> iteratorInternal();

    public void eventOccured(ContextEvent ev) {
        for (ContextListener<T> listener : this.listeners) {
            listener.eventOccured(ev);
        }
    }

    @Override
    public void addSubContext(Context<? extends T> context) {
        this.subContexts.put(context.getId(), context);
        for (Object obj : context) {
            this.fireAddContextEvent(obj);
        }
        context.addContextListener(this);
        this.fireSubContextAdded(context);
    }

    @Override
    public boolean hasSubContext() {
        return this.subContexts.values().size() > 0;
    }

    @Override
    public Iterable<Context<? extends T>> getSubContexts() {
        return this.subContexts.values();
    }

    @Override
    public void removeSubContext(Context<? extends T> context) {
        this.subContexts.remove(context.getId());
        for (Object obj : context) {
            this.fireRemoveEvent(obj);
        }
        context.removeContextListener(this);
        this.fireSubContextRemoved(context);
    }

    @Override
    public final boolean remove(Object o) {
        boolean result = false;
        result = this.handleRemove(o);
        if (this.removeInternal(o)) {
            result = true;
        }
        if (result) {
            this.fireRemoveEvent(o);
        }
        return result;
    }

    @Override
    public void clear() {
        HashSet<T> set = new HashSet<T>();
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        for (Object obj : set) {
            this.remove(obj);
        }
    }

    protected boolean handleRemove(Object o) {
        boolean result = false;
        for (Context<T> child : this.subContexts.values()) {
            if (!child.remove(o)) continue;
            result = true;
        }
        return result;
    }

    protected void fireRemoveEvent(Object o) {
        this.fireContextEvent(new ContextEvent<Object>(ContextEvent.EventType.AGENT_REMOVED, this, o));
    }

    protected void fireSubContextAdded(Context<? extends T> context) {
        this.fireContextEvent(new ContextEvent<T>(ContextEvent.EventType.SUBCONTEXT_ADDED, this, context));
    }

    protected void fireSubContextRemoved(Context<? extends T> context) {
        this.fireContextEvent(new ContextEvent<T>(ContextEvent.EventType.SUBCONTEXT_REMOVED, this, context));
    }

    protected abstract boolean removeInternal(Object var1);

    @Override
    public int size() {
        int size = this.sizeInternal();
        for (Context<T> context : this.getSubContexts()) {
            size += context.size();
        }
        return size;
    }

    protected abstract int sizeInternal();

    @Override
    public Context<? extends T> getSubContext(Object id) {
        return this.subContexts.get(id);
    }

    @Override
    public Context findParent(Object o) {
        Context contextFound = null;
        ArrayList<AbstractContext> list = new ArrayList<AbstractContext>();
        list.add(this);
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            Context context = (Context)iter.next();
            if (!context.contains(o)) continue;
            contextFound = context;
            if (context.getSubContexts() == null) break;
            iter = context.getSubContexts().iterator();
        }
        return contextFound;
    }

    @Override
    public Context findContext(Object id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.getSubContext(id) != null) {
            return this.getSubContext(id);
        }
        for (Map.Entry<Object, Context<T>> subContext : this.subContexts.entrySet()) {
            Context resSub = subContext.getValue().findContext(id);
            if (resSub == null) continue;
            return resSub;
        }
        return null;
    }

    @Override
    public Iterable<Class> getAgentTypes() {
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.addAll(this.agentClasses);
        for (Context<T> sub : this.getSubContexts()) {
            for (Class c : sub.getAgentTypes()) {
                set.add(c);
            }
        }
        return set;
    }

    @Override
    public Iterable<T> getAgentLayer(Class<T> agentType) {
        return this.query(PredicateUtils.instanceofPredicate(agentType));
    }

    @Override
    public <X extends Projection<?>> X getProjection(Class<X> projection, String name) {
        return (X)this.projectionMap.get(name);
    }

    @Override
    public <X extends Projection<?>> Iterable<X> getProjections(Class<X> clazz) {
        return new IterableAdaptor(new FilterIterator(this.projectionMap.values().iterator(), PredicateUtils.instanceofPredicate(clazz)));
    }

    @Override
    public Projection<?> getProjection(String name) {
        return this.projectionMap.get(name);
    }

    @Override
    public void addProjection(Projection<? super T> projection) {
        if (this.projectionMap.containsKey(projection.getName())) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Projection '" + projection.getName() + "' has already been added\n" + "Note that projection factories automatically add the projection to the context."), (Throwable)new IllegalArgumentException("Duplicate projections added."), new Object[0]);
            return;
        }
        if (projection instanceof ContextListener) {
            this.addContextListener((ContextListener)((Object)projection));
        }
        this.fireContextEvent(new ContextEvent<T>(ContextEvent.EventType.PROJECTION_ADDED, this, projection));
        this.projectionMap.put(projection.getName(), projection);
    }

    @Override
    public Projection<? super T> removeProjection(String projectionName) {
        Projection<?> proj = this.projectionMap.remove(projectionName);
        if (proj == null) {
            return null;
        }
        this.fireContextEvent(new ContextEvent(ContextEvent.EventType.PROJECTION_REMOVED, (Context<?>)this, proj));
        if (proj instanceof ContextListener) {
            this.removeContextListener((ContextListener)((Object)proj));
        }
        return proj;
    }

    private void fireContextEvent(ContextEvent<T> evt) {
        for (ContextListener<T> listener : this.listeners) {
            listener.eventOccured(evt);
        }
    }

    @Override
    public Collection<Projection<?>> getProjections() {
        return this.projectionMap.values();
    }

    @Override
    public void addValueLayer(ValueLayer valueLayer) {
        this.valueLayerMap.put(valueLayer.getName(), valueLayer);
    }

    @Override
    public ValueLayer removeValueLayer(String name) {
        return this.valueLayerMap.remove(name);
    }

    @Override
    public Collection<ValueLayer> getValueLayers() {
        return this.valueLayerMap.values();
    }

    @Override
    public ValueLayer getValueLayer(String name) {
        return this.valueLayerMap.get(name);
    }
}

