/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.adaptation.regression;

import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Forecaster;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.MultipleLinearRegressionModel;

public class RepastRegressionModel {
    public ForecastingModel model;
    public DataSet history = new DataSet();
    public boolean findBest = false;
    public String dependentVariableName = "X";
    public String independentVariableName = "Y";
    public boolean recalculate = false;

    public RepastRegressionModel(boolean newFindBest) {
        this.findBest = newFindBest;
    }

    public void add(double x, double ... yValues) {
        Observation dataPoint = new Observation(x);
        dataPoint.setIndependentValue(this.dependentVariableName, x);
        int yIndex = 0;
        double[] dArray = yValues;
        int n = yValues.length;
        int n2 = 0;
        while (n2 < n) {
            double y = dArray[n2];
            dataPoint.setIndependentValue(String.valueOf(this.independentVariableName) + yIndex++, y);
            ++n2;
        }
        this.history.add((Object)dataPoint);
        this.recalculate = true;
    }

    public double forecast(double ... yValues) {
        Observation dataPoint = new Observation(0.0);
        int yIndex = 0;
        String[] independentVariableNames = new String[yValues.length];
        double[] dArray = yValues;
        int n = yValues.length;
        int n2 = 0;
        while (n2 < n) {
            double y = dArray[n2];
            independentVariableNames[yIndex] = String.valueOf(this.independentVariableName) + yIndex;
            dataPoint.setIndependentValue(independentVariableNames[yIndex], y);
            ++yIndex;
            ++n2;
        }
        if (this.model == null) {
            this.model = this.findBest ? Forecaster.getBestForecast((DataSet)this.history) : new MultipleLinearRegressionModel(independentVariableNames);
        }
        if (this.recalculate) {
            this.model.init(this.history);
            this.recalculate = false;
        }
        return this.model.forecast((DataPoint)dataPoint);
    }

    public String getForecastType() {
        return this.model.getForecastType();
    }
}

