/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.adaptation.neural;

import org.joone.engine.DirectSynapse;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.engine.learning.ComparingElement;
import org.joone.net.NeuralNet;
import repast.simphony.adaptation.neural.NeuralUtils;

public class RepastNeuralWrapper
implements NeuralNetListener {
    private static final long serialVersionUID = 3257846575983114032L;
    protected NeuralNet net;
    protected int epochsPerIteration = 1;
    protected transient boolean netStopped = true;
    private transient Object networkRunningMonitor = new Object();

    public RepastNeuralWrapper() {
        this(new NeuralNet());
    }

    public RepastNeuralWrapper(NeuralNet net) {
        this.net = net;
        net.removeAllListeners();
        net.addNeuralNetListener((NeuralNetListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pattern retrieve(InputPatternListener in) throws Exception {
        ComparingElement teacher = this.net.getTeacher();
        DirectSynapse out = new DirectSynapse();
        this.net.removeAllInputs();
        this.net.removeAllOutputs();
        this.net.addInputSynapse(in);
        this.net.addOutputSynapse((OutputPatternListener)out);
        Monitor monitor = this.net.getMonitor();
        monitor.setTrainingPatterns(1);
        monitor.setTotCicles(1);
        monitor.setLearning(false);
        this.net.start();
        if (!(in instanceof DirectSynapse)) {
            this.net.getMonitor().Go();
        }
        Pattern retPattern = out.fwdGet();
        this.net.stop();
        if (!(in instanceof DirectSynapse)) {
            this.net.getMonitor().Stop();
        }
        try {
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                while (!this.netStopped) {
                    this.networkRunningMonitor.wait();
                }
            }
        }
        catch (InterruptedException ex) {
            throw new Exception("Error waiting for net to stop", ex);
        }
        this.waitTilNetTrulyStops();
        this.net.setTeacher(teacher);
        return retPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void train(InputPatternListener in) throws Exception {
        ComparingElement teacher = this.net.getTeacher();
        this.net.removeAllInputs();
        this.net.removeAllOutputs();
        this.net.setTeacher(teacher);
        this.net.addInputSynapse(in);
        this.net.addOutputSynapse((OutputPatternListener)teacher);
        this.net.getMonitor().setLearning(true);
        this.net.start();
        this.net.getMonitor().Go();
        try {
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                while (!this.netStopped) {
                    this.networkRunningMonitor.wait();
                }
            }
        }
        catch (InterruptedException ex) {
            throw new Exception("Error waiting for net to stop", ex);
        }
        this.waitTilNetTrulyStops();
    }

    private synchronized void waitTilNetTrulyStops() throws Exception {
        int i = 0;
        while (this.net.isRunning() && i < 100) {
            try {
                Thread.sleep(3L);
                if (i == 50) {
                    this.net.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        if (this.net.isRunning()) {
            throw new Exception("Couldn't stop network");
        }
    }

    public synchronized int getEpochsPerIteration() {
        return this.epochsPerIteration;
    }

    public synchronized void setEpochsPerIteration(int epochsPerIteration) {
        this.epochsPerIteration = epochsPerIteration;
    }

    public void netStarted(NeuralNetEvent e) {
        this.netStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netStopped(NeuralNetEvent e) {
        if (!this.netStopped) {
            this.netStopped = true;
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                this.networkRunningMonitor.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netStoppedError(NeuralNetEvent e, String error) {
        System.out.println("STOPPED ON ERROR");
        if (!this.netStopped) {
            this.netStopped = true;
            Object object = this.networkRunningMonitor;
            synchronized (object) {
                this.networkRunningMonitor.notify();
            }
        }
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public synchronized NeuralNet getNet() {
        return this.net;
    }

    public synchronized void setNet(NeuralNet net) {
        this.net = net;
    }

    public void saveNetToFile(String fileName) throws Exception {
        this.net.removeNeuralNetListener((NeuralNetListener)this);
        NeuralUtils.saveNetToFile(this.net, fileName);
        this.net.addNeuralNetListener((NeuralNetListener)this);
    }
}

