/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.adaptation.neural;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.engine.learning.ComparingElement;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.net.NeuralNet;
import repast.simphony.adaptation.neural.RepastNeuralWrapper;

public class NeuralUtils {
    private NeuralUtils() {
    }

    public static RepastNeuralWrapper buildNetwork(int[] nodesPerLayer, Class layerType, Class synapseType) throws Exception {
        Class[] layerTypes = new Class[nodesPerLayer.length];
        int i = 0;
        while (i < nodesPerLayer.length) {
            layerTypes[i] = layerType;
            ++i;
        }
        Class[] synapseTypes = new Class[nodesPerLayer.length - 1];
        int i2 = 0;
        while (i2 < nodesPerLayer.length - 1) {
            synapseTypes[i2] = synapseType;
            ++i2;
        }
        return NeuralUtils.buildNetwork(nodesPerLayer, layerTypes, synapseTypes);
    }

    public static RepastNeuralWrapper buildNetwork(int[] nodesPerLayer, Class[] layerTypes, Class[] synapseTypes) throws Exception, IllegalArgumentException {
        if (nodesPerLayer.length != layerTypes.length || layerTypes.length - 1 != synapseTypes.length) {
            throw new IllegalArgumentException("In NeuralUtils.buildNetwork, the lengthof the passed in arrays must be nodesPerLayer.length == layerTypes.length andlayerTypes.length - 1 == synapseTypes.length");
        }
        try {
            NeuralNet net = new NeuralNet();
            RepastNeuralWrapper netWrapper = new RepastNeuralWrapper(net);
            if (nodesPerLayer.length == 0) {
                return netWrapper;
            }
            Layer prevLayer = null;
            int i = 0;
            while (i < nodesPerLayer.length) {
                Layer layer = (Layer)layerTypes[i].newInstance();
                layer.setRows(nodesPerLayer[i]);
                if (prevLayer != null) {
                    NeuralUtils.linkLayers(prevLayer, layer, synapseTypes[i - 1]);
                }
                if (i == 0) {
                    net.addLayer(layer, 0);
                    layer.setLayerName("Input Layer");
                } else if (i < nodesPerLayer.length - 1) {
                    net.addLayer(layer, 1);
                    layer.setLayerName("Hidden Layer (" + (i - 1) + ")");
                } else {
                    net.addLayer(layer, 2);
                    layer.setLayerName("Output Layer");
                }
                prevLayer = layer;
                ++i;
            }
            net.setTeacher((ComparingElement)new TeachingSynapse());
            return netWrapper;
        }
        catch (InstantiationException ex) {
            throw new Exception("NeuralUtils.linkLayers: Couldn't create an instance of the specified layer/synapse type\nDo both classes supply default constructors?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new Exception("NeuralUtils.linkLayers: Couldn't create an instance of the specified layer/synapse type\nDo both classes supply default constructors?", ex);
        }
    }

    public static Synapse linkLayers(Layer outLayer, Layer inLayer, Class synapseType) throws Exception {
        try {
            Synapse synapse = (Synapse)synapseType.newInstance();
            inLayer.addInputSynapse((InputPatternListener)synapse);
            outLayer.addOutputSynapse((OutputPatternListener)synapse);
            return synapse;
        }
        catch (InstantiationException ex) {
            throw new Exception("NeuralUtils.linkLayers: Couldn't create an instance of the specified synapse type", ex);
        }
        catch (IllegalAccessException ex) {
            throw new Exception("NeuralUtils.linkLayers: Couldn't create an instance of the specified synapse type", ex);
        }
    }

    public static void saveNetToFile(NeuralNet net, String fileName) throws Exception {
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(stream);
            out.writeObject(net);
            out.close();
        }
        catch (Exception ex) {
            throw new Exception("Error saving net to file: " + ex.getMessage(), ex);
        }
    }

    public static RepastNeuralWrapper loadNetFromFile(String fileName) throws Exception {
        NeuralNet nnet = null;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            ObjectInputStream input = new ObjectInputStream(stream);
            nnet = (NeuralNet)input.readObject();
        }
        catch (Exception ex) {
            throw new Exception("Error loading network from file", ex);
        }
        nnet.start();
        nnet.getMonitor().Go();
        nnet.stop();
        return new RepastNeuralWrapper(nnet);
    }
}

