/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.adaptation.ga;

import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.InvalidConfigurationException;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.DoubleGene;
import org.jgap.impl.IntegerGene;
import repast.simphony.adaptation.ga.RepastFitnessFunction;

public class RepastGA {
    Configuration configuration = new DefaultConfiguration();
    Genotype population = null;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Genotype getPopulation() {
        return this.population;
    }

    public void setPopulation(Genotype population) {
        this.population = population;
    }

    public RepastGA(Object fitnessFunction, String fitnessFunctionName, int populationSize, Gene[] sampleGenes) {
        try {
            if (fitnessFunction instanceof FitnessFunction && fitnessFunctionName.equals("evaluate")) {
                this.configuration.setFitnessFunction((FitnessFunction)fitnessFunction);
            } else {
                this.configuration.setFitnessFunction((FitnessFunction)new RepastFitnessFunction(fitnessFunction, fitnessFunctionName));
            }
            Chromosome sampleChromosome = new Chromosome(this.configuration, sampleGenes);
            this.configuration.setSampleChromosome(sampleChromosome);
            this.configuration.setPopulationSize(populationSize);
            this.population = Genotype.randomInitialGenotype((Configuration)this.configuration);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public double[] getBestSolution(int cycles) {
        this.population.evolve();
        return RepastGA.chromosomeToGene(this.population.getFittestChromosome());
    }

    public Gene[] getBestSolutionAsGene(int cycles) {
        this.population.evolve();
        return this.population.getFittestChromosome().getGenes();
    }

    public Chromosome getBestSolutionAsChromosome(int cycles) {
        this.population.evolve();
        return this.population.getFittestChromosome();
    }

    public void reset() {
        try {
            this.population = Genotype.randomInitialGenotype((Configuration)this.configuration);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static double[] chromosomeToGene(Chromosome chromosome) {
        int geneCount = chromosome.getGenes().length;
        if (geneCount > 0) {
            double[] geneValues = new double[geneCount];
            int i = 0;
            Gene[] geneArray = chromosome.getGenes();
            int n = geneArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gene gene = geneArray[n2];
                geneValues[i] = gene instanceof IntegerGene ? (double)((IntegerGene)gene).intValue() : (gene instanceof DoubleGene ? ((DoubleGene)gene).doubleValue() : 0.0);
                ++i;
                ++n2;
            }
            return geneValues;
        }
        return null;
    }
}

