/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.xml.sax.helpers.AttributesImpl;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.FloatSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.LongSteppedSetter;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.xml.ListSetterCreator;
import repast.simphony.parameter.xml.NumberSetterCreator;
import repast.simphony.parameter.xml.ParameterSweepParser;
import repast.simphony.util.collections.Pair;

public class XMLTester
extends TestCase {
    public void testParse() {
        try {
            ParameterSweepParser parser = new ParameterSweepParser(((Object)((Object)this)).getClass().getResource("params.xml"));
            Pair<Parameters, ParameterTreeSweeper> out = parser.parse();
            ParameterTreeSweeper sweeper = (ParameterTreeSweeper)out.getSecond();
            XMLTester.assertEquals((int)2, (int)sweeper.getRunCount());
            ParameterSetter root = sweeper.getRootParameterSetter();
            Collection<ParameterSetter> children = sweeper.getChildren(root);
            XMLTester.assertEquals((int)7, (int)children.size());
            HashSet<String> names = new HashSet<String>();
            LongSteppedSetter iSetter = null;
            for (ParameterSetter setter : children) {
                if (setter instanceof LongSteppedSetter) {
                    iSetter = (LongSteppedSetter)setter;
                    names.add(((LongSteppedSetter)setter).getParameterName());
                }
                if (!(setter instanceof ConstantSetter)) continue;
                names.add(((ConstantSetter)setter).getParameterName());
            }
            XMLTester.assertTrue((boolean)names.contains("num_1"));
            XMLTester.assertTrue((boolean)names.contains("const_1"));
            XMLTester.assertTrue((boolean)names.contains("const_2"));
            XMLTester.assertTrue((boolean)names.contains("const_3"));
            XMLTester.assertTrue((boolean)names.contains("const_4"));
            XMLTester.assertTrue((boolean)names.contains("const_5"));
            XMLTester.assertTrue((boolean)names.contains("const_6"));
            XMLTester.assertEquals((String)"num_1", (String)iSetter.getParameterName());
            children = sweeper.getChildren(iSetter);
            XMLTester.assertEquals((int)3, (int)children.size());
            HashSet<Class<IntSteppedSetter>> types = new HashSet<Class<IntSteppedSetter>>();
            types.add(DoubleSteppedSetter.class);
            types.add(FloatSteppedSetter.class);
            types.add(IntSteppedSetter.class);
            HashMap<String, ParameterSetter> map = new HashMap<String, ParameterSetter>();
            for (ParameterSetter ps : children) {
                XMLTester.assertTrue((boolean)types.remove(ps.getClass()));
                if (ps instanceof DoubleSteppedSetter) {
                    map.put(((DoubleSteppedSetter)ps).getParameterName(), ps);
                }
                if (ps instanceof FloatSteppedSetter) {
                    map.put(((FloatSteppedSetter)ps).getParameterName(), ps);
                }
                if (!(ps instanceof IntSteppedSetter)) continue;
                map.put(((IntSteppedSetter)ps).getParameterName(), ps);
            }
            XMLTester.assertEquals((int)0, (int)types.size());
            XMLTester.assertTrue((boolean)map.containsKey("num_2"));
            XMLTester.assertTrue((boolean)map.containsKey("num_3"));
            XMLTester.assertTrue((boolean)map.containsKey("num_4"));
            children = sweeper.getChildren((ParameterSetter)map.get("num_2"));
            XMLTester.assertEquals((int)1, (int)children.size());
            ListParameterSetter lSetter = (ListParameterSetter)children.iterator().next();
            XMLTester.assertEquals((String)"list_val", (String)lSetter.getParameterName());
            children = sweeper.getChildren(lSetter);
            XMLTester.assertEquals((int)0, (int)children.size());
            children = sweeper.getChildren((ParameterSetter)map.get("num_3"));
            XMLTester.assertEquals((int)0, (int)children.size());
            children = sweeper.getChildren((ParameterSetter)map.get("num_4"));
            XMLTester.assertEquals((int)0, (int)children.size());
            Parameters params = (Parameters)out.getFirst();
            names = new HashSet();
            names.add("num_1");
            names.add("num_2");
            names.add("num_3");
            names.add("num_4");
            names.add("list_val");
            names.add("const_1");
            names.add("const_2");
            names.add("const_3");
            names.add("const_4");
            names.add("const_5");
            names.add("const_6");
            for (String name : params.getSchema().parameterNames()) {
                XMLTester.assertTrue((boolean)names.remove(name));
            }
            XMLTester.assertEquals((Object)new Long(1L), (Object)params.getValue("num_1"));
            XMLTester.assertEquals((Object)new Float(0.3), (Object)params.getValue("num_2"));
            XMLTester.assertEquals((Object)new Double(0.9), (Object)params.getValue("num_3"));
            XMLTester.assertEquals((Object)new Integer(2), (Object)params.getValue("num_4"));
            XMLTester.assertEquals((Object)new Float(0.3f), (Object)params.getValue("const_1"));
            XMLTester.assertEquals((Object)new Double(0.2), (Object)params.getValue("const_2"));
            XMLTester.assertEquals((Object)new Integer(11), (Object)params.getValue("const_3"));
            XMLTester.assertEquals((Object)new Long(11L), (Object)params.getValue("const_4"));
            XMLTester.assertEquals((Object)"hello cormac", (Object)params.getValue("const_5"));
            XMLTester.assertEquals((Object)Boolean.FALSE, (Object)params.getValue("const_6"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XMLTester.assertTrue((boolean)false);
        }
    }

    public void testPattern() {
        boolean val = Pattern.matches("\\-?\\d*\\.\\d+", "1");
        XMLTester.assertTrue((!val ? 1 : 0) != 0);
        val = Pattern.matches("\\-?\\d*\\.\\d+", "-1");
        XMLTester.assertTrue((!val ? 1 : 0) != 0);
        val = Pattern.matches("\\-?\\d*\\.\\d+", "-1.0");
        XMLTester.assertTrue((boolean)val);
        val = Pattern.matches("\\-?\\d*\\.\\d+", "1.0");
        XMLTester.assertTrue((boolean)val);
    }

    public void testSimpleStringListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "string");
            attributes.addAttribute("values", "values", "values", "", "foo bar baz");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)"foo", (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)"bar", (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)"baz", (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testIntListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "int");
            attributes.addAttribute("values", "values", "values", "", "32 12 -4");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)32, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)12, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)-4, (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testLongListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "long");
            attributes.addAttribute("values", "values", "values", "", "32 12 -4");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)32L, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)12L, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)-4L, (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testBooleanListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "boolean");
            attributes.addAttribute("values", "values", "values", "", "true false true");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)true, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)false, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)true, (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testDoubleListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "double");
            attributes.addAttribute("values", "values", "values", "", ".12343 132342.23423 1.23");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)0.12343, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)132342.23423, (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)1.23, (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testFloatListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "float");
            attributes.addAttribute("values", "values", "values", "", ".12343 132342.23423 1.23");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)Float.valueOf(0.12343f), (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)Float.valueOf(132342.23f), (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)Float.valueOf(1.23f), (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testStringListSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "list_value");
            attributes.addAttribute("value_type", "value_type", "value_type", "", "string");
            attributes.addAttribute("values", "values", "values", "", "'fo\"o . ' 'bar' 'b az'");
            ListSetterCreator creator = new ListSetterCreator();
            creator.init(attributes);
            ListParameterSetter setter = (ListParameterSetter)creator.createSetter();
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            setter.reset(params);
            XMLTester.assertEquals((Object)"fo\"o . ", (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)"bar", (Object)params.getValue("list_value"));
            setter.next(params);
            XMLTester.assertEquals((Object)"b az", (Object)params.getValue("list_value"));
            XMLTester.assertTrue((boolean)setter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testIntSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "aParam");
            attributes.addAttribute("start", "start", "start", "", "1");
            attributes.addAttribute("end", "end", "end", "", "4");
            attributes.addAttribute("step", "step", "step", "", "1");
            NumberSetterCreator creator = new NumberSetterCreator();
            creator.init(attributes);
            ParameterSetter setter = creator.createSetter();
            XMLTester.assertTrue((boolean)(setter instanceof IntSteppedSetter));
            IntSteppedSetter iSetter = (IntSteppedSetter)setter;
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            iSetter.reset(params);
            XMLTester.assertEquals((Object)1, (Object)params.getValue("aParam"));
            iSetter.next(params);
            XMLTester.assertEquals((Object)2, (Object)params.getValue("aParam"));
            iSetter.next(params);
            XMLTester.assertEquals((Object)3, (Object)params.getValue("aParam"));
            iSetter.next(params);
            XMLTester.assertEquals((Object)4, (Object)params.getValue("aParam"));
            XMLTester.assertTrue((boolean)iSetter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }

    public void testDoubleSetterCreator() {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("name", "name", "name", "", "aParam");
            attributes.addAttribute("start", "start", "start", "", "1");
            attributes.addAttribute("end", "end", "end", "", "2");
            attributes.addAttribute("step", "step", "step", "", ".1");
            NumberSetterCreator creator = new NumberSetterCreator();
            creator.init(attributes);
            ParameterSetter setter = creator.createSetter();
            XMLTester.assertTrue((boolean)(setter instanceof DoubleSteppedSetter));
            DoubleSteppedSetter iSetter = (DoubleSteppedSetter)setter;
            ParametersCreator pc = new ParametersCreator();
            creator.addParameter(pc);
            Parameters params = pc.createParameters();
            iSetter.reset(params);
            double i = 1.0;
            while (i < 2.0) {
                XMLTester.assertEquals((double)i, (double)((Double)params.getValue("aParam")), (double)1.0E-4);
                iSetter.next(params);
                i += 0.1;
            }
            XMLTester.assertTrue((boolean)iSetter.atEnd());
        }
        catch (ParameterFormatException e) {
            e.printStackTrace();
        }
    }
}

