/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.xml.ConstantBooleanSetterCreator;
import repast.simphony.parameter.xml.ConstantNumberSetterCreator;
import repast.simphony.parameter.xml.ConstantObjectSetterCreator;
import repast.simphony.parameter.xml.ConstantStringSetterCreator;
import repast.simphony.parameter.xml.ListSetterCreator;
import repast.simphony.parameter.xml.NumberSetterCreator;
import repast.simphony.parameter.xml.ObjectListSetterCreator;
import repast.simphony.parameter.xml.ParameterSetterCreator;
import repast.simphony.util.collections.Pair;

public class ParameterSweepParser
extends DefaultHandler2 {
    private static final String PARAMETER_NAME = "parameter";
    private static final String SWEEP = "sweep";
    private URL paramsURL;
    private InputStream inputStream;
    private Stack<ParameterSetter> stack = new Stack();
    private ParameterTreeSweeper sweeper = new ParameterTreeSweeper();
    private Map<String, ParameterSetterCreator> creators = new HashMap<String, ParameterSetterCreator>();
    private Map<String, ParameterSetterCreator> constantCreators = new HashMap<String, ParameterSetterCreator>();
    private ConstantObjectSetterCreator objCreator = new ConstantObjectSetterCreator();
    private ObjectListSetterCreator objListCreator = new ObjectListSetterCreator();
    private ParametersCreator creator = new ParametersCreator();

    public ParameterSweepParser(URL paramsURL) {
        this.paramsURL = paramsURL;
        this.init();
    }

    public ParameterSweepParser(InputStream in) {
        this.inputStream = in;
        this.init();
    }

    private void init() {
        this.creators.put("number", new NumberSetterCreator());
        this.creators.put("list", new ListSetterCreator());
        this.constantCreators.put("string", new ConstantStringSetterCreator());
        this.constantCreators.put("String", new ConstantStringSetterCreator());
        this.constantCreators.put("boolean", new ConstantBooleanSetterCreator());
        this.constantCreators.put("java.lang.Boolean", new ConstantBooleanSetterCreator());
        this.constantCreators.put("java.lang.String", new ConstantStringSetterCreator());
        this.constantCreators.put("java.lang.Integer", new ConstantNumberSetterCreator("java.lang.Integer"));
        this.constantCreators.put("java.lang.Double", new ConstantNumberSetterCreator("java.lang.Double"));
        this.constantCreators.put("java.lang.Float", new ConstantNumberSetterCreator("java.lang.Float"));
        this.constantCreators.put("java.lang.Long", new ConstantNumberSetterCreator("java.lang.Long"));
        this.constantCreators.put("java.lang.Short", new ConstantNumberSetterCreator("java.lang.Short"));
        this.constantCreators.put("java.lang.Byte", new ConstantNumberSetterCreator("java.lang.Byte"));
        this.constantCreators.put("int", new ConstantNumberSetterCreator("java.lang.Integer"));
        this.constantCreators.put("double", new ConstantNumberSetterCreator("java.lang.Double"));
        this.constantCreators.put("float", new ConstantNumberSetterCreator("java.lang.Float"));
        this.constantCreators.put("long", new ConstantNumberSetterCreator("java.lang.Long"));
        this.constantCreators.put("short", new ConstantNumberSetterCreator("java.lang.Short"));
        this.constantCreators.put("byte", new ConstantNumberSetterCreator("java.lang.Byte"));
    }

    public ParameterSweepParser(ParameterTreeSweeper sweeper, URL paramsURL) {
        this(paramsURL);
        this.sweeper = sweeper;
    }

    public Pair<Parameters, ParameterTreeSweeper> parse() throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        if (this.inputStream == null) {
            this.inputStream = this.paramsURL.openStream();
        }
        parser.parse(this.inputStream, (DefaultHandler)this);
        this.inputStream.close();
        return new Pair((Object)this.creator.createParameters(), (Object)this.sweeper);
    }

    public void inputFile(String input) throws IOException {
        boolean mjbSuggest = false;
        if (!mjbSuggest) {
            String file = "./batch.xml";
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(input);
            out.close();
            this.paramsURL = new File(this.paramsURL.getPath()).toURL();
        } else {
            File tFile = File.createTempFile(SWEEP, ".xml");
            System.out.println("TempFile: <" + tFile.getName() + ">");
            String file = tFile.getName();
            file = tFile.getAbsolutePath();
            tFile.delete();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(input);
            out.close();
            this.paramsURL = new File(file).toURL();
        }
    }

    public String readFile(URL url, int size) throws IOException {
        this.paramsURL = url;
        byte[] b = new byte[size];
        InputStream inputStream = this.paramsURL.openStream();
        inputStream.read(b);
        String params = new String(b);
        return params;
    }

    public void registerStepperCreator(String typeID, ParameterSetterCreator creator) {
        this.creators.put(typeID, creator);
    }

    public void registerConstantCreator(String constantTypeID, ParameterSetterCreator creator) {
        this.constantCreators.put(constantTypeID, creator);
    }

    private void checkForCustomType(Attributes attributes) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(SWEEP)) {
            this.sweeper.setRunCount(Integer.parseInt(attributes.getValue("runs")));
        } else if (qName.equals(PARAMETER_NAME)) {
            try {
                String type = attributes.getValue("type");
                ParameterSetterCreator setterCreator = null;
                if (type.equals("constant")) {
                    String cType = attributes.getValue("constant_type");
                    if (cType.equals("number")) {
                        cType = this.inferDataTypeForConstant(attributes);
                    }
                    if ((setterCreator = this.constantCreators.get(cType)) == null) {
                        setterCreator = this.objCreator;
                    }
                } else if (type.equals("list") && attributes.getValue("value_type") != null) {
                    String listType = attributes.getValue("value_type");
                    setterCreator = this.constantCreators.keySet().contains(listType) ? this.creators.get(type) : this.objListCreator;
                } else {
                    setterCreator = this.creators.get(type);
                }
                setterCreator.init(attributes);
                setterCreator.addParameter(this.creator);
                ParameterSetter setter = setterCreator.createSetter();
                if (this.stack.isEmpty()) {
                    ParameterSetter root = this.sweeper.getRootParameterSetter();
                    this.sweeper.add(root, setter);
                } else {
                    this.sweeper.add(this.stack.peek(), setter);
                }
                this.stack.push(setter);
            }
            catch (ParameterFormatException ex) {
                SAXException e = new SAXException(ex.getMessage(), (Exception)((Object)ex));
                e.initCause(ex);
                throw e;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(PARAMETER_NAME)) {
            this.stack.pop();
        }
    }

    private String inferDataTypeForConstant(Attributes attributes) {
        String value = attributes.getValue("value");
        return this.inferDataType(value);
    }

    private String inferDataType(String value) {
        if (this.isLong(value)) {
            return "long";
        }
        if (this.isFloat(value)) {
            return "float";
        }
        if (this.isDouble(value)) {
            return "double";
        }
        return "int";
    }

    protected boolean isDouble(String val) {
        return Pattern.matches("\\d*\\.\\d+", val);
    }

    protected boolean isLong(String val) {
        String end = val.substring(val.length() - 1, val.length());
        return end.equalsIgnoreCase("l");
    }

    protected boolean isFloat(String val) {
        String end = val.substring(val.length() - 1, val.length());
        return end.equalsIgnoreCase("f");
    }

    protected boolean isInt(Double value) {
        return Math.rint(value) == value;
    }

    private String attributesToString(Attributes attributes) {
        StringBuilder builder = new StringBuilder("[");
        int i = 0;
        while (i < attributes.getLength()) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(attributes.getQName(i));
            builder.append("=\"");
            builder.append(attributes.getValue(i));
            builder.append("\"");
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }
}

