/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import java.util.Map;
import org.xml.sax.Attributes;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.ListTokenizer;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.StringConverter;
import repast.simphony.parameter.xml.AbstractParameterSetterCreator;

public class ObjectListSetterCreator
extends AbstractParameterSetterCreator {
    private Object[] vals;
    private Class<?> type;
    private StringConverter<?> converter;

    @Override
    public void addParameter(ParametersCreator creator) {
        creator.addParameter(this.name, this.type, this.vals[0], false);
        creator.addConvertor(this.name, this.converter);
    }

    @Override
    public void init(Attributes attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    @Override
    public void init(Map<String, String> attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    private void doInit() throws ParameterFormatException {
        String sType = this.attributes.getValue("value_type");
        try {
            this.type = Class.forName(sType);
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterFormatException("Error parsing batch parameter '" + this.name + "'", (Throwable)ex);
        }
        String clz = this.attributes.getValue("converter");
        if (clz == null) {
            throw new ParameterFormatException("Invalid parameter format. Parameter '" + this.name + "' is missing " + "converter" + " attribute");
        }
        try {
            Class<?> clazz = Class.forName(clz);
            this.converter = (StringConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ParameterFormatException("Error while creating converter '" + clz + "' for batch parameter '" + this.name + "'", (Throwable)ex);
        }
        String[] sVals = ListTokenizer.parseStringValues((String)this.attributes.getValue("values"));
        this.vals = new Object[sVals.length];
        int i = 0;
        String[] stringArray = sVals;
        int n = sVals.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            this.vals[i++] = this.converter.fromString(val);
            ++n2;
        }
    }

    @Override
    public ParameterSetter createSetter() {
        return new ListParameterSetter<Object>(this.name, this.vals);
    }
}

