/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import java.util.Map;
import org.xml.sax.Attributes;
import repast.simphony.parameter.ByteSteppedSetter;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.FloatSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.LongSteppedSetter;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.ShortSteppedSetter;
import repast.simphony.parameter.xml.AbstractNumberSetterCreator;

public class NumberSetterCreator
extends AbstractNumberSetterCreator {
    public static final String START = "start";
    public static final String END = "end";
    public static final String STEP = "step";
    public static final String NUMBERTYPE = "number_type";
    private Double start;
    private Double end;
    private Double step;

    @Override
    public void init(Attributes attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    @Override
    public void init(Map<String, String> attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    private void doInit() throws ParameterFormatException {
        try {
            String startStr = this.attributes.getValue(START);
            String endStr = this.attributes.getValue(END);
            String stepStr = this.attributes.getValue(STEP);
            this.initType(startStr, endStr, stepStr);
            if (this.type == AbstractNumberSetterCreator.Type.FLOAT || this.type == AbstractNumberSetterCreator.Type.LONG) {
                startStr = this.trim(startStr);
                endStr = this.trim(endStr);
                stepStr = this.trim(stepStr);
            }
            this.start = Double.valueOf(startStr);
            this.end = Double.valueOf(endStr);
            this.step = Double.valueOf(stepStr);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + this.name + "'", (Throwable)ex);
        }
    }

    private void initType(String start, String end, String step) {
        String numberType = this.attributes.getValue(NUMBERTYPE);
        if (numberType == null) {
            numberType = this.isFloat(start) || this.isFloat(end) || this.isFloat(step) ? "float" : (this.isLong(start) || this.isLong(end) || this.isLong(step) ? "long" : (this.isDouble(start) || this.isDouble(end) || this.isDouble(step) ? "double" : "int"));
        }
        if (numberType.equals("long") || numberType.equals("java.lang.Long")) {
            this.type = AbstractNumberSetterCreator.Type.LONG;
        } else if (numberType.equals("int") || numberType.equals("java.lang.Integer")) {
            this.type = AbstractNumberSetterCreator.Type.INT;
        } else if (numberType.equals("double") || numberType.equals("java.lang.Double")) {
            this.type = AbstractNumberSetterCreator.Type.DOUBLE;
        } else if (numberType.equals("float") || numberType.equals("java.lang.Float")) {
            this.type = AbstractNumberSetterCreator.Type.FLOAT;
        } else if (numberType.equals("short") || numberType.equals("java.lang.Short")) {
            this.type = AbstractNumberSetterCreator.Type.SHORT;
        } else if (numberType.equals("byte") || numberType.equals("java.lang.Byte")) {
            this.type = AbstractNumberSetterCreator.Type.BYTE;
        }
    }

    private String inferDataType(String value) {
        if (value.endsWith("L")) {
            return "long";
        }
        if (value.endsWith("f")) {
            return "float";
        }
        if (value.contains(".") && value.length() > 1) {
            return "double";
        }
        return "int";
    }

    @Override
    public void addParameter(ParametersCreator creator) {
        if (this.type == AbstractNumberSetterCreator.Type.DOUBLE) {
            creator.addParameter(this.name, Double.class, (Object)this.start, false);
        } else if (this.type == AbstractNumberSetterCreator.Type.INT) {
            creator.addParameter(this.name, Integer.class, (Object)new Integer(this.start.intValue()), false);
        } else if (this.type == AbstractNumberSetterCreator.Type.LONG) {
            creator.addParameter(this.name, Long.class, (Object)new Long(this.start.longValue()), false);
        } else if (this.type == AbstractNumberSetterCreator.Type.SHORT) {
            creator.addParameter(this.name, Short.class, (Object)new Short(this.start.shortValue()), false);
        } else if (this.type == AbstractNumberSetterCreator.Type.BYTE) {
            creator.addParameter(this.name, Byte.class, (Object)new Byte(this.start.byteValue()), false);
        } else {
            creator.addParameter(this.name, Float.class, (Object)new Float(this.start.floatValue()), false);
        }
    }

    @Override
    public ParameterSetter createSetter() {
        if (this.type == AbstractNumberSetterCreator.Type.DOUBLE) {
            return new DoubleSteppedSetter(this.name, this.start, this.end, this.step);
        }
        if (this.type == AbstractNumberSetterCreator.Type.INT) {
            return new IntSteppedSetter(this.name, this.start.intValue(), this.end.intValue(), this.step.intValue());
        }
        if (this.type == AbstractNumberSetterCreator.Type.LONG) {
            return new LongSteppedSetter(this.name, this.start.longValue(), this.end.longValue(), this.step.longValue());
        }
        if (this.type == AbstractNumberSetterCreator.Type.SHORT) {
            return new ShortSteppedSetter(this.name, this.start.shortValue(), this.end.shortValue(), this.step.shortValue());
        }
        if (this.type == AbstractNumberSetterCreator.Type.BYTE) {
            return new ByteSteppedSetter(this.name, this.start.byteValue(), this.end.byteValue(), this.step.byteValue());
        }
        return new FloatSteppedSetter(this.name, this.start.floatValue(), this.end.floatValue(), this.step.floatValue());
    }
}

