/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.ListTokenizer;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.xml.AbstractParameterSetterCreator;

public class ListSetterCreator
extends AbstractParameterSetterCreator {
    private Object[] vals;
    private String valueType;
    private Map<String, Class> typeMap = new HashMap<String, Class>();

    public ListSetterCreator() {
        this.typeMap.put("String", String.class);
        this.typeMap.put("string", String.class);
        this.typeMap.put("java.lang.String", String.class);
        this.typeMap.put("int", Integer.class);
        this.typeMap.put("java.lang.Integer", Integer.class);
        this.typeMap.put("double", Double.class);
        this.typeMap.put("java.lang.Double", Double.class);
        this.typeMap.put("float", Float.class);
        this.typeMap.put("java.lang.Float", Float.class);
        this.typeMap.put("long", Long.class);
        this.typeMap.put("java.lang.Long", Long.class);
        this.typeMap.put("boolean", Boolean.class);
        this.typeMap.put("java.lang.Boolean", Boolean.class);
        this.typeMap.put("byte", Byte.class);
        this.typeMap.put("java.lang.Byte", Byte.class);
        this.typeMap.put("short", Short.class);
        this.typeMap.put("java.lang.Short", Short.class);
    }

    @Override
    public void addParameter(ParametersCreator creator) {
        creator.addParameter(this.name, this.typeMap.get(this.valueType), this.vals[0], false);
    }

    @Override
    public void init(Attributes attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    @Override
    public void init(Map<String, String> attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    private void doInit() throws ParameterFormatException {
        this.valueType = this.attributes.getValue("value_type");
        String values = this.attributes.getValue("values");
        if (this.valueType.equalsIgnoreCase("String") || this.valueType.equalsIgnoreCase("java.lang.String")) {
            this.vals = ListTokenizer.parseStringValues((String)values);
        } else if (this.valueType.equals("int") || this.valueType.equalsIgnoreCase("java.lang.Integer")) {
            this.vals = ListTokenizer.parseIntValues((String)values, (String)this.name);
        } else if (this.valueType.equals("double") || this.valueType.equalsIgnoreCase("java.lang.Double")) {
            this.vals = ListTokenizer.parseDoubleValues((String)values, (String)this.name);
        } else if (this.valueType.equals("float") || this.valueType.equalsIgnoreCase("java.lang.Float")) {
            this.vals = ListTokenizer.parseFloatValues((String)values, (String)this.name);
        } else if (this.valueType.equals("long") || this.valueType.equalsIgnoreCase("java.lang.Long")) {
            this.vals = ListTokenizer.parseLongValues((String)values, (String)this.name);
        } else if (this.valueType.equals("boolean") || this.valueType.equalsIgnoreCase("java.lang.Boolean")) {
            this.vals = ListTokenizer.parseBooleanValues((String)values, (String)this.name);
        } else if (this.valueType.equals("short") || this.valueType.equalsIgnoreCase("java.lang.Short")) {
            this.vals = ListTokenizer.parseShortValues((String)values, (String)this.name);
        } else if (this.valueType.equals("byte") || this.valueType.equalsIgnoreCase("java.lang.Byte")) {
            this.vals = ListTokenizer.parseByteValues((String)values, (String)this.name);
        } else {
            throw new ParameterFormatException("Unsupported list value type '" + this.valueType + "'");
        }
    }

    @Override
    public ParameterSetter createSetter() {
        return this.createSetter(this.name, this.typeMap.get(this.valueType));
    }

    private <T> ParameterSetter createSetter(String name, Class<T> clazz) {
        return new ListParameterSetter<Object>(name, this.vals);
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("'(?>\\\\.|.)*?'");
        Matcher m1 = p.matcher("'f.k .k\" \"oo' '. bar' 'baz'");
        while (m1.find()) {
            System.out.println(m1.group());
        }
    }
}

