/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import org.xml.sax.Attributes;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.StringConverter;
import repast.simphony.parameter.xml.AbstractParameterSetterCreator;

public class ConstantObjectSetterCreator
extends AbstractParameterSetterCreator {
    private Object value;
    private Class<?> type;
    private StringConverter<?> converter;

    @Override
    public void init(Attributes attributes) throws ParameterFormatException {
        super.init(attributes);
        String sValue = attributes.getValue("value");
        String sType = attributes.getValue("constant_type");
        try {
            this.type = Class.forName(sType);
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterFormatException("Error parsing batch parameter '" + this.name + "'", (Throwable)ex);
        }
        String clz = attributes.getValue("converter");
        if (clz == null) {
            throw new ParameterFormatException("Invalid parameter format. Parameter '" + this.name + "' is missing " + "converter" + " attribute");
        }
        try {
            Class<?> clazz = Class.forName(clz);
            this.converter = (StringConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ParameterFormatException("Error while creating converter '" + clz + "' for batch parameter '" + this.name + "'", (Throwable)ex);
        }
        this.value = this.converter.fromString(sValue);
    }

    @Override
    public void addParameter(ParametersCreator creator) {
        creator.addParameter(this.name, this.type, this.value, false);
        creator.addConvertor(this.name, this.converter);
    }

    @Override
    public ParameterSetter createSetter() {
        return new ConstantSetter(this.name, this.value);
    }
}

