/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.xml;

import java.util.Map;
import org.xml.sax.Attributes;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.xml.AbstractNumberSetterCreator;

public class ConstantNumberSetterCreator
extends AbstractNumberSetterCreator {
    private Double val;
    private String javaClass;

    public ConstantNumberSetterCreator(String javaClass) {
        this.javaClass = javaClass;
        this.initType();
    }

    @Override
    public void init(Attributes attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    @Override
    public void init(Map<String, String> attributes) throws ParameterFormatException {
        super.init(attributes);
        this.doInit();
    }

    private void doInit() throws ParameterFormatException {
        try {
            String valStr = this.attributes.getValue("value");
            if (this.type == AbstractNumberSetterCreator.Type.FLOAT || this.type == AbstractNumberSetterCreator.Type.LONG) {
                valStr = this.trim(valStr);
            }
            this.val = Double.valueOf(valStr);
        }
        catch (NumberFormatException ex) {
            throw new ParameterFormatException("Invalid format for parameter '" + this.name + "'", (Throwable)ex);
        }
    }

    private void initType(String val) {
        this.type = this.isFloat(val) ? AbstractNumberSetterCreator.Type.FLOAT : (this.isLong(val) ? AbstractNumberSetterCreator.Type.LONG : AbstractNumberSetterCreator.Type.DOUBLE);
    }

    @Override
    public void addParameter(ParametersCreator creator) {
        if (this.type == AbstractNumberSetterCreator.Type.DOUBLE) {
            creator.addParameter(this.name, Double.class, (Object)this.val, false);
        } else if (this.type == AbstractNumberSetterCreator.Type.INT) {
            creator.addParameter(this.name, Integer.class, (Object)new Integer(this.val.intValue()), false);
        } else if (this.type == AbstractNumberSetterCreator.Type.LONG) {
            creator.addParameter(this.name, Long.class, (Object)new Long(this.val.longValue()), false);
        } else if (this.type == AbstractNumberSetterCreator.Type.SHORT) {
            creator.addParameter(this.name, Short.class, (Object)new Short(this.val.shortValue()), false);
        } else if (this.type == AbstractNumberSetterCreator.Type.BYTE) {
            creator.addParameter(this.name, Byte.class, (Object)new Byte(this.val.byteValue()), false);
        } else {
            creator.addParameter(this.name, Float.class, (Object)new Float(this.val.floatValue()), false);
        }
    }

    @Override
    public ParameterSetter createSetter() {
        if (this.type == AbstractNumberSetterCreator.Type.DOUBLE) {
            return new ConstantSetter(this.name, (Object)this.val);
        }
        if (this.type == AbstractNumberSetterCreator.Type.INT) {
            return new ConstantSetter(this.name, (Object)this.val.intValue());
        }
        if (this.type == AbstractNumberSetterCreator.Type.LONG) {
            return new ConstantSetter(this.name, (Object)this.val.longValue());
        }
        if (this.type == AbstractNumberSetterCreator.Type.SHORT) {
            return new ConstantSetter(this.name, (Object)this.val.shortValue());
        }
        if (this.type == AbstractNumberSetterCreator.Type.BYTE) {
            return new ConstantSetter(this.name, (Object)this.val.byteValue());
        }
        return new ConstantSetter(this.name, (Object)Float.valueOf(this.val.floatValue()));
    }

    private void initType() {
        if (this.javaClass.equals("long") || this.javaClass.equals("java.lang.Long")) {
            this.type = AbstractNumberSetterCreator.Type.LONG;
        } else if (this.javaClass.equals("int") || this.javaClass.equals("java.lang.Integer")) {
            this.type = AbstractNumberSetterCreator.Type.INT;
        } else if (this.javaClass.equals("double") || this.javaClass.equals("java.lang.Double")) {
            this.type = AbstractNumberSetterCreator.Type.DOUBLE;
        } else if (this.javaClass.equals("float") || this.javaClass.equals("java.lang.Float")) {
            this.type = AbstractNumberSetterCreator.Type.FLOAT;
        } else if (this.javaClass.equals("short") || this.javaClass.equals("java.lang.Short")) {
            this.type = AbstractNumberSetterCreator.Type.SHORT;
        } else if (this.javaClass.equals("byte") || this.javaClass.equals("java.lang.Byte")) {
            this.type = AbstractNumberSetterCreator.Type.BYTE;
        }
    }
}

