/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.optimizer;

import java.util.LinkedList;
import repast.simphony.context.Context;
import repast.simphony.engine.controller.NullAbstractControllerAction;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.graph.EngineGraphUtilities;
import repast.simphony.engine.graph.Executor;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.RunResultProducer;
import repast.simphony.parameter.optimizer.AdvanceType;
import repast.simphony.parameter.optimizer.AdvancementChooser;
import repast.simphony.parameter.optimizer.OptimizableParameterSetter;
import repast.simphony.space.graph.Traverser;

public class OptimizedParameterSweeper
extends ParameterTreeSweeper {
    protected RunResultProducer resultProducer;
    protected AdvancementChooser advancementChooser;
    protected boolean firstStepRandom = false;
    protected int index = 0;
    protected ParameterSetter[] flatTree;
    protected double runValue;
    protected AdvanceType lastAdvancement;
    protected boolean finished;
    protected ParameterSetter lastSetter;
    protected double previousRunValue;
    protected int lastIndex;
    protected boolean resetIndex;

    public OptimizedParameterSweeper(ControllerRegistry registry, Object masterContextId) {
        this(registry, masterContextId, new DefaultAdvanceChooser());
    }

    public OptimizedParameterSweeper(ControllerRegistry registry, Object masterContextId, DefaultAdvanceChooser chooser) {
        this.advancementChooser = chooser;
        this.resetValues();
        this.addResultProducerAction(registry, masterContextId);
    }

    protected void addResultProducerAction(ControllerRegistry registry, Object masterContextId) {
        registry.addAction(masterContextId, null, (ControllerAction)new NullAbstractControllerAction(){

            public void runCleanup(RunState runState, Context context) {
                OptimizedParameterSweeper.this.previousRunValue = OptimizedParameterSweeper.this.runValue;
                OptimizedParameterSweeper.this.runValue = OptimizedParameterSweeper.this.resultProducer.getRunValue(runState);
            }
        });
    }

    protected void flattenTree() {
        final LinkedList flatTree = new LinkedList();
        EngineGraphUtilities.breadthFirstMap((Executor)new Executor<ParameterSetter>(){

            public void execute(ParameterSetter toExecuteOn) {
                flatTree.add(toExecuteOn);
            }
        }, (Traverser)this.traverser, (Object)this.rootSetter);
        this.flatTree = flatTree.toArray(new ParameterSetter[flatTree.size()]);
        this.index = this.flatTree.length - 1;
    }

    @Override
    public boolean atEnd() {
        return this.finished;
    }

    @Override
    protected Parameters nextParameters(final Parameters params) {
        if (this.flatTree == null) {
            this.flattenTree();
        }
        OptimizableParameterSetter advancedInit = null;
        if (this.lastSetter instanceof OptimizableParameterSetter) {
            advancedInit = (OptimizableParameterSetter)this.lastSetter;
        }
        if (this.advancementChooser.shouldRevert(this.runValue)) {
            if (this.lastAdvancement == AdvanceType.RANDOM) {
                EngineGraphUtilities.breadthFirstMap((Executor)new Executor<ParameterSetter>(){

                    public void execute(ParameterSetter toExecuteOn) {
                        if (toExecuteOn instanceof OptimizableParameterSetter) {
                            OptimizableParameterSetter advancedInit = (OptimizableParameterSetter)toExecuteOn;
                            advancedInit.revert(params);
                        }
                    }
                }, (Traverser)this.traverser, (Object)this.rootSetter);
            } else if (advancedInit != null) {
                advancedInit.revert(params);
            }
            if (this.resetIndex) {
                this.index = this.lastIndex;
            }
            this.runValue = this.previousRunValue;
        }
        this.resetIndex = false;
        boolean usedSetter = false;
        while (!usedSetter) {
            AdvanceType newAdvancement;
            if (this.index < 1) {
                this.finished = true;
                break;
            }
            this.lastSetter = this.flatTree[this.index];
            this.lastIndex = this.index;
            advancedInit = null;
            if (this.lastSetter instanceof OptimizableParameterSetter) {
                advancedInit = (OptimizableParameterSetter)this.lastSetter;
            }
            this.lastAdvancement = newAdvancement = this.advancementChooser.chooseAdvancement(this.lastSetter, this.lastAdvancement, this.runValue);
            switch (newAdvancement) {
                case SWITCH: {
                    --this.index;
                    break;
                }
                case FORWARD: {
                    if (this.lastSetter.atEnd()) {
                        --this.index;
                        break;
                    }
                    this.lastSetter.next(params);
                    this.updateChildren(this.lastSetter, params);
                    usedSetter = true;
                    break;
                }
                case BACKWARD: {
                    if (advancedInit == null || advancedInit.atBeginning()) {
                        --this.index;
                        break;
                    }
                    advancedInit.previous(params);
                    this.updateChildren(this.lastSetter, params);
                    usedSetter = true;
                    break;
                }
                case RANDOM: {
                    this.executeRandom(this.rootSetter, false, params);
                    this.resetIndex();
                    usedSetter = true;
                }
            }
        }
        return params;
    }

    private void updateChildren(ParameterSetter init, Parameters params) {
        if (this.paramTree.getChildren((Object)init).size() > 0) {
            this.resetIndex();
        }
    }

    private void resetIndex() {
        this.resetIndex = true;
        this.index = this.flatTree.length - 1;
    }

    private Parameters executeRandom(ParameterSetter setter, final boolean executeAll, final Parameters params) {
        EngineGraphUtilities.breadthFirstMap((Executor)new Executor<ParameterSetter>(){

            public void execute(ParameterSetter toExecuteOn) {
                if (toExecuteOn instanceof OptimizableParameterSetter) {
                    OptimizableParameterSetter advancedSetter = (OptimizableParameterSetter)toExecuteOn;
                    advancedSetter.random(params);
                } else if (executeAll) {
                    toExecuteOn.next(params);
                }
            }
        }, (Traverser)this.traverser, (Object)setter);
        return params;
    }

    @Override
    protected Parameters firstParameters(Parameters params) {
        if (!this.firstStepRandom) {
            return super.firstParameters(params);
        }
        return this.executeRandom(this.rootSetter, true, params);
    }

    protected void resetValues() {
        this.runValue = Double.NEGATIVE_INFINITY;
        this.lastAdvancement = null;
        this.finished = false;
        this.flatTree = null;
    }

    @Override
    public void reset(Parameters params) {
        this.resetValues();
        super.reset(params);
    }

    public AdvancementChooser getAdvancementChooser() {
        return this.advancementChooser;
    }

    public void setAdvancementChooser(AdvancementChooser chooser) {
        this.advancementChooser = chooser;
    }

    public boolean isFirstStepRandom() {
        return this.firstStepRandom;
    }

    public void setFirstStepRandom(boolean firstStepRandom) {
        this.firstStepRandom = firstStepRandom;
    }

    public RunResultProducer getResultProducer() {
        return this.resultProducer;
    }

    public void setResultProducer(RunResultProducer resultProducer) {
        this.resultProducer = resultProducer;
    }

    public static class DefaultAdvanceChooser
    implements AdvancementChooser {
        public AdvanceType advanceParameter(double runResult) {
            return AdvanceType.FORWARD;
        }

        @Override
        public boolean shouldRevert(double runResult) {
            return false;
        }

        @Override
        public AdvanceType chooseAdvancement(ParameterSetter init, AdvanceType lastType, double runResult) {
            return AdvanceType.FORWARD;
        }
    }
}

