/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.optimizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import repast.simphony.parameter.RunResultProducer;
import repast.simphony.parameter.optimizer.AdvancementChooser;

public class OptPropertiesParser {
    private static final String RUN_RESULT_PRODUCER = "run_result_producer";
    private static final String PARAMS_FILE = "parameter_file";
    private static final String BEAN_SHELL_SCRIPT = "bean_shell_script";
    private static final String ADVANCEMENT_CHOOSER = "advancement_chooser";
    private Properties props = new Properties();

    public OptPropertiesParser(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        this.props.load(inStream);
        inStream.close();
        if (!this.props.containsKey(RUN_RESULT_PRODUCER)) {
            throw new IOException("Properties file must specify a RunResultProducer implementation");
        }
        if (!this.props.containsKey(PARAMS_FILE) && !this.props.containsKey(BEAN_SHELL_SCRIPT)) {
            throw new IOException("Properties file must specify a parameters file or a bean shell framework style script");
        }
    }

    public RunResultProducer getRunResultProducer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String runResultProducer = this.props.getProperty(RUN_RESULT_PRODUCER);
        Class<?> clazz = Class.forName(runResultProducer);
        return (RunResultProducer)clazz.newInstance();
    }

    public AdvancementChooser getAdvancementChooser() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String chooser = this.props.getProperty(ADVANCEMENT_CHOOSER);
        if (chooser != null) {
            Class<?> clazz = Class.forName(chooser);
            return (AdvancementChooser)clazz.newInstance();
        }
        return null;
    }

    public String getParametersFile() {
        return this.props.getProperty(PARAMS_FILE);
    }

    public String getBSFScript() {
        return this.props.getProperty(BEAN_SHELL_SCRIPT);
    }
}

