/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.optimizer;

import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.optimizer.AdvanceType;
import repast.simphony.parameter.optimizer.AdvancementChooser;
import repast.simphony.parameter.optimizer.OptimizableParameterSetter;

public class HillClimber
implements AdvancementChooser {
    protected double lastValue = Double.NEGATIVE_INFINITY;
    protected boolean checkingLocal = true;
    protected boolean forwardValid = false;
    protected double forwardValue;
    protected double centerValue;
    protected ParameterSetter lastSetter;
    private boolean checkingForward;
    private double backwardValue;
    private boolean checkingBackward;

    @Override
    public AdvanceType chooseAdvancement(ParameterSetter setter, AdvanceType lastType, double runResult) {
        ParameterSetter previousInit = this.lastSetter;
        this.lastSetter = setter;
        OptimizableParameterSetter advancedInit = null;
        if (setter instanceof OptimizableParameterSetter) {
            advancedInit = (OptimizableParameterSetter)setter;
        }
        double previousRunValue = this.lastValue;
        this.lastValue = runResult;
        if (previousInit != setter) {
            this.checkingLocal = true;
            this.centerValue = runResult;
            this.checkingBackward = false;
            if (!setter.atEnd()) {
                this.checkingForward = true;
                return AdvanceType.FORWARD;
            }
            if (advancedInit != null && !advancedInit.atBeginning()) {
                this.forwardValue = Double.NEGATIVE_INFINITY;
                this.checkingForward = false;
                this.checkingBackward = true;
                return AdvanceType.BACKWARD;
            }
            this.checkingLocal = false;
            this.checkingForward = false;
            return AdvanceType.SWITCH;
        }
        if (this.checkingLocal) {
            if (this.checkingForward) {
                this.checkingForward = false;
                if (advancedInit == null || advancedInit.atBeginning()) {
                    if (this.forwardValue > this.centerValue) {
                        this.lastValue = this.centerValue;
                        this.checkingLocal = false;
                        return AdvanceType.FORWARD;
                    }
                    return AdvanceType.SWITCH;
                }
                this.checkingBackward = true;
                return AdvanceType.BACKWARD;
            }
            if (this.checkingBackward) {
                this.checkingLocal = false;
                this.checkingBackward = false;
                double maxValue = Math.max(this.forwardValue, Math.max(this.backwardValue, this.centerValue));
                if (maxValue == this.centerValue) {
                    return AdvanceType.SWITCH;
                }
                if (maxValue == this.forwardValue) {
                    this.lastValue = this.centerValue;
                    return AdvanceType.FORWARD;
                }
                this.lastValue = this.centerValue;
                return AdvanceType.BACKWARD;
            }
        }
        if (previousRunValue >= runResult) {
            return AdvanceType.SWITCH;
        }
        return lastType;
    }

    @Override
    public boolean shouldRevert(double runResult) {
        if (this.checkingLocal) {
            if (this.checkingForward) {
                this.forwardValue = runResult;
            } else if (this.checkingBackward) {
                this.backwardValue = runResult;
            }
            return true;
        }
        return this.lastValue > runResult;
    }
}

