/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.optimizer;

import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.optimizer.AdvanceType;
import repast.simphony.parameter.optimizer.CoolingSchedule;
import repast.simphony.parameter.optimizer.DefaultExponentialCoolingSchedule;
import repast.simphony.parameter.optimizer.HillClimber;
import repast.simphony.random.RandomHelper;

public class AnnealingAdvancementChooser
extends HillClimber {
    public static final double DEFAULT_INITIAL_TEMP = 1000.0;
    protected CoolingSchedule coolingSchedule;
    protected double maxTemp;
    protected boolean jumped;
    protected AdvanceType preJumpAdvance;
    protected double preJumpRunResult;
    private boolean reverted;

    public AnnealingAdvancementChooser() {
        this(new DefaultExponentialCoolingSchedule(), 1000.0);
    }

    public AnnealingAdvancementChooser(CoolingSchedule schedule, double initialTemp) {
        this.coolingSchedule = schedule;
        this.maxTemp = initialTemp;
        this.coolingSchedule.init(initialTemp);
        this.preJumpAdvance = AdvanceType.FORWARD;
        this.jumped = false;
    }

    @Override
    public AdvanceType chooseAdvancement(ParameterSetter init, AdvanceType lastType, double runResult) {
        AdvanceType advance;
        if (!this.chooseRandom()) {
            if (this.jumped && this.reverted) {
                advance = super.chooseAdvancement(init, this.preJumpAdvance, this.preJumpRunResult);
                if (advance != AdvanceType.SWITCH) {
                    this.jumped = false;
                }
            } else {
                advance = super.chooseAdvancement(init, lastType, runResult);
                this.jumped = false;
            }
        } else {
            this.preJumpRunResult = runResult;
            this.preJumpAdvance = lastType;
            this.jumped = true;
            advance = AdvanceType.RANDOM;
        }
        return advance;
    }

    @Override
    public boolean shouldRevert(double runResult) {
        if (this.jumped) {
            if (runResult <= this.preJumpRunResult) {
                this.reverted = true;
            } else {
                this.lastSetter = null;
                this.reverted = false;
            }
            return this.reverted;
        }
        return super.shouldRevert(runResult);
    }

    protected boolean chooseRandom() {
        return this.getRandom() < this.coolingSchedule.cool();
    }

    protected double getRandom() {
        return RandomHelper.getUniform().nextDoubleFromTo(0.0, this.maxTemp);
    }
}

