/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.groovy;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.groovy.GroovyRunner;

public class GroovyRunnerTest
extends TestCase {
    public void testValidGroovyRunner() {
        File file = new File("./test_scripts/params.groovy");
        GroovyRunner runner = new GroovyRunner(file);
        try {
            Parameters params = runner.getParameters();
            GroovyRunnerTest.assertEquals((Object)new Integer(2), (Object)params.getValue("const_1"));
            GroovyRunnerTest.assertEquals((Object)new Integer(1), (Object)params.getValue("num_1"));
            GroovyRunnerTest.assertEquals((int)3, (int)runner.getParameterSweeper().getRunCount());
        }
        catch (IOException e) {
            e.printStackTrace();
            GroovyRunnerTest.fail((String)e.getMessage());
        }
    }

    public void testInvalidGroovyRunner() {
        File file = new File("./test_scripts/bad_params.groovy");
        GroovyRunner runner = new GroovyRunner(file);
        try {
            runner.getParameters();
            GroovyRunnerTest.fail((String)"file eval should throw exception");
        }
        catch (IOException e) {
            GroovyRunnerTest.assertTrue((boolean)true);
        }
    }

    public void testCustomParam() {
        File file = new File("./test_scripts/custom.groovy");
        GroovyRunner runner = new GroovyRunner(file);
        try {
            Parameters params = runner.getParameters();
            GroovyRunnerTest.assertEquals((Object)new Integer(2), (Object)params.getValue("num_1"));
            GroovyRunnerTest.assertEquals((int)3, (int)runner.getParameterSweeper().getRunCount());
        }
        catch (IOException e) {
            e.printStackTrace();
            GroovyRunnerTest.fail((String)e.getMessage());
        }
    }
}

