/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import repast.simphony.context.Context;
import repast.simphony.engine.controller.NullAbstractControllerAction;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.RunState;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.SweeperProducer;
import repast.simphony.parameter.groovy.CustomParameterSetter;
import repast.simphony.parameter.groovy.ParameterBuilder;

public class GroovyRunner
implements SweeperProducer {
    private File script;
    private ParameterBuilder builder;

    public GroovyRunner(File script) {
        this.script = script;
    }

    @Override
    public ParameterTreeSweeper getParameterSweeper() throws IOException {
        if (this.builder == null) {
            this.run();
        }
        return this.builder.getSweeper();
    }

    private void run() throws IOException {
        try {
            this.builder = new ParameterBuilder();
            Binding binding = new Binding();
            binding.setVariable("builder", (Object)this.builder);
            GroovyShell shell = new GroovyShell(binding);
            shell.evaluate(this.script);
        }
        catch (Exception ex) {
            IOException exception = new IOException(ex.getMessage());
            exception.initCause(ex);
            throw exception;
        }
    }

    @Override
    public Parameters getParameters() throws IOException {
        if (this.builder == null) {
            this.run();
        }
        return this.builder.getParameters();
    }

    @Override
    public void init(ControllerRegistry registry, Object masterContextId) {
        if (registry != null) {
            registry.addAction(masterContextId, null, (ControllerAction)new NullAbstractControllerAction(){

                public void runInitialize(RunState runState, Context context, Parameters runParams) {
                    try {
                        ParameterTreeSweeper sweeper = GroovyRunner.this.getParameterSweeper();
                        this.initCustomParameters(runState, sweeper, sweeper.getRootParameterSetter());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                private void initCustomParameters(RunState state, ParameterTreeSweeper sweeper, ParameterSetter setter) {
                    if (setter instanceof CustomParameterSetter) {
                        ((CustomParameterSetter)setter).init(state);
                    }
                    for (ParameterSetter child : sweeper.getChildren(setter)) {
                        this.initCustomParameters(state, sweeper, child);
                    }
                }
            });
        }
    }
}

