/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter.bsf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.parameter.ParameterSweeperBuilder;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.RunResultProducer;
import repast.simphony.parameter.SweeperProducer;
import repast.simphony.parameter.optimizer.AdvancementChooser;
import repast.simphony.parameter.optimizer.OptimizedParameterSweeper;

public class ScriptRunner
implements SweeperProducer {
    private ParameterSweeperBuilder builder;
    private File file;
    private RunResultProducer producer;
    private AdvancementChooser chooser = new OptimizedParameterSweeper.DefaultAdvanceChooser();
    private boolean run = true;

    public ScriptRunner(RunResultProducer producer, File file) {
        this.file = file;
        this.producer = producer;
    }

    public ScriptRunner(RunResultProducer producer, AdvancementChooser chooser, File file) {
        this.file = file;
        this.producer = producer;
        this.chooser = chooser;
    }

    public ScriptRunner(File file) {
        this.file = file;
    }

    @Override
    public void init(ControllerRegistry registry, Object masterContextId) {
        if (this.producer == null) {
            this.builder = new ParameterSweeperBuilder();
        } else {
            OptimizedParameterSweeper sweeper = new OptimizedParameterSweeper(registry, masterContextId);
            sweeper.setResultProducer(this.producer);
            sweeper.setAdvancementChooser(this.chooser);
            this.builder = new ParameterSweeperBuilder(sweeper);
        }
    }

    private void run() throws IOException {
        try {
            String line;
            String lang = BSFManager.getLangFromFilename((String)this.file.getAbsolutePath());
            BSFManager manager = new BSFManager();
            manager.declareBean("builder", (Object)this.builder, this.builder.getClass());
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            StringBuilder str = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                str.append(line);
                str.append("\n");
            }
            reader.close();
            manager.exec(lang, this.file.getAbsolutePath(), 1, 1, (Object)str.toString());
        }
        catch (BSFException e) {
            IOException ex = new IOException("Error running script file");
            ex.initCause(e);
            throw ex;
        }
        this.run = false;
    }

    @Override
    public Parameters getParameters() throws IOException {
        if (this.run) {
            this.run();
        }
        return this.builder.getParameters();
    }

    @Override
    public ParameterTreeSweeper getParameterSweeper() throws IOException {
        if (this.run) {
            this.run();
        }
        return this.builder.getSweeper();
    }
}

