/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import repast.simphony.parameter.AbstractSweepParameterSetter;

public class ShortSteppedSetter
extends AbstractSweepParameterSetter<Short> {
    private short stepSize;
    private short max;
    private short base;

    public ShortSteppedSetter(String parameterName, short base, short max, short step) {
        super(parameterName);
        this.base = base;
        this.stepSize = step;
        this.max = max;
    }

    @Override
    public Short resetValue() {
        return this.base;
    }

    @Override
    public boolean atEnd(Short prevValue) {
        if (prevValue == null) {
            return false;
        }
        return prevValue + this.stepSize > this.max;
    }

    @Override
    public boolean atBeginning(Short prevValue) {
        if (prevValue == null) {
            return true;
        }
        return prevValue - this.stepSize < this.base;
    }

    @Override
    protected Short nextValue(Short prevValue) {
        if (prevValue == null) {
            prevValue = this.base;
        }
        return (short)(prevValue + this.stepSize);
    }

    @Override
    protected Short randomValue() {
        int numSteps = (int)Math.floor((this.max - this.base) / this.stepSize);
        int steps = this.randInt(0, numSteps);
        return (short)(steps * this.stepSize + this.base);
    }

    @Override
    protected Short previousValue(Short prevValue) {
        if (prevValue == null) {
            prevValue = (short)(this.base + this.stepSize);
        }
        return (short)(prevValue - this.stepSize);
    }

    public String toString() {
        return "[short " + this.parameterName + " " + this.base + ".." + this.max + "," + this.stepSize + "]";
    }
}

