/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.Collection;
import junit.framework.TestCase;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.RunParameterSetter;

public class ParameterTreeSweeperTest
extends TestCase {
    private Parameters params;
    private ParameterTreeSweeper sweeper;

    protected void setUp() throws Exception {
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("name", String.class, (Object)"nameValue", false);
        creator.addParameter("intRange", Integer.class, (Object)1, false);
        creator.addParameter("doubleRange", Double.class, (Object)0.3333333333333333, false);
        creator.addParameter("doubleList", Double.class, (Object)100, false);
        this.params = creator.createParameters();
        this.sweeper = new ParameterTreeSweeper();
    }

    private void incrementSweeper() {
        this.sweeper.next(this.params);
        System.out.println(this.params.getValue("name") + ", " + this.params.getValue("intRange") + ", " + this.params.getValue("doubleRange") + ", " + this.params.getValue("doubleList"));
    }

    private void helperTestSweep(Object[][] expected) {
        int i = 0;
        while (i < expected.length) {
            ParameterTreeSweeperTest.assertTrue((String)"Sweeper has no more steps.", (!this.sweeper.atEnd() ? 1 : 0) != 0);
            this.incrementSweeper();
            ParameterTreeSweeperTest.assertEquals((Object)expected[i][0], (Object)this.params.getValue("name"));
            ParameterTreeSweeperTest.assertEquals((Object)expected[i][1], (Object)this.params.getValue("intRange"));
            ParameterTreeSweeperTest.assertEquals((double)((Double)expected[i][2]), (double)((Double)this.params.getValue("doubleRange")), (double)1.0E-5);
            ParameterTreeSweeperTest.assertEquals((Object)expected[i][3], (Object)this.params.getValue("doubleList"));
            ++i;
        }
        if (!this.sweeper.atEnd()) {
            System.out.println("Failure: sweeper steps remain:");
            while (!this.sweeper.atEnd()) {
                this.incrementSweeper();
            }
            ParameterTreeSweeperTest.fail((String)"Sweeper steps remain. See above.");
        }
        ParameterTreeSweeperTest.assertFalse((!this.sweeper.atEnd() ? 1 : 0) != 0);
    }

    public void testRootCount() {
        ConstantSetter nameInit = new ConstantSetter("name", (Object)"nameValue");
        ParameterSetter root = this.sweeper.getRootParameterSetter();
        this.sweeper.add(root, (ParameterSetter)nameInit);
        Collection<ParameterSetter> children = this.sweeper.getChildren(root);
        ParameterTreeSweeperTest.assertEquals((int)1, (int)children.size());
    }

    public void testExpectedOutputChain() {
        ConstantSetter nameInit = new ConstantSetter("name", (Object)"nameValue");
        IntSteppedSetter intRangeInit = new IntSteppedSetter("intRange", 1, 3, 1);
        DoubleSteppedSetter doubleRangeInit = new DoubleSteppedSetter("doubleRange", 0.3333333333333333, 1.0, 0.3333333333333333);
        ListParameterSetter<Double> doubleListInit = new ListParameterSetter<Double>("doubleList", new Double[]{100.0, 200.0});
        this.sweeper.add(this.sweeper.getRootParameterSetter(), (ParameterSetter)nameInit);
        this.sweeper.add((ParameterSetter)nameInit, intRangeInit);
        this.sweeper.add(intRangeInit, doubleRangeInit);
        this.sweeper.add(doubleRangeInit, doubleListInit);
        Object[][] expectedValuesChain = new Object[][]{{"nameValue", 1, 0.3333333333333333, 100.0}, {"nameValue", 1, 0.3333333333333333, 200.0}, {"nameValue", 1, 0.6666666666666666, 100.0}, {"nameValue", 1, 0.6666666666666666, 200.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 1, 1.0, 200.0}, {"nameValue", 2, 0.3333333333333333, 100.0}, {"nameValue", 2, 0.3333333333333333, 200.0}, {"nameValue", 2, 0.6666666666666666, 100.0}, {"nameValue", 2, 0.6666666666666666, 200.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 2, 1.0, 200.0}, {"nameValue", 3, 0.3333333333333333, 100.0}, {"nameValue", 3, 0.3333333333333333, 200.0}, {"nameValue", 3, 0.6666666666666666, 100.0}, {"nameValue", 3, 0.6666666666666666, 200.0}, {"nameValue", 3, 1.0, 100.0}, {"nameValue", 3, 1.0, 200.0}};
        this.helperTestSweep(expectedValuesChain);
    }

    public void testExpectedOutputChainUsingConvenienceMethod() {
        this.params.setValue("name", (Object)"nameValue");
        this.params.setValue("doubleList", (Object)100.0);
        this.sweeper.addIntRange("intRange", 1, 3, 1);
        this.sweeper.addDoubleRange("doubleRange", 0.5, 2.0, 0.5);
        Object[][] expectedValuesChain = new Object[][]{{"nameValue", 1, 0.5, 100.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 1, 1.5, 100.0}, {"nameValue", 1, 2.0, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 2, 1.5, 100.0}, {"nameValue", 2, 2.0, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 3, 1.0, 100.0}, {"nameValue", 3, 1.5, 100.0}, {"nameValue", 3, 2.0, 100.0}};
        this.helperTestSweep(expectedValuesChain);
    }

    public void testExpectedOutputRuns() {
        this.params.setValue("name", (Object)"nameValue");
        this.params.setValue("intRange", (Object)1);
        this.params.setValue("doubleRange", (Object)0.5);
        this.params.setValue("doubleList", (Object)100.0);
        this.sweeper.addIntRange("intRange", 1, 3, 1);
        Object[][] expectedValuesChain = new Object[][]{{"nameValue", 1, 0.5, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 3, 0.5, 100.0}};
        this.helperTestSweep(expectedValuesChain);
        this.sweeper.reset(this.params);
        this.sweeper.setRunCount(2);
        expectedValuesChain = new Object[][]{{"nameValue", 1, 0.5, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 1, 0.5, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 3, 0.5, 100.0}};
        this.helperTestSweep(expectedValuesChain);
        this.sweeper.reset(this.params);
        this.sweeper.addDoubleRange("doubleRange", 0.5, 1.0, 0.5);
        expectedValuesChain = new Object[][]{{"nameValue", 1, 0.5, 100.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 3, 1.0, 100.0}, {"nameValue", 1, 0.5, 100.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 3, 1.0, 100.0}};
        this.helperTestSweep(expectedValuesChain);
        this.sweeper.reset(this.params);
        this.sweeper.setRunCount(3);
        expectedValuesChain = new Object[][]{{"nameValue", 1, 0.5, 100.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 3, 1.0, 100.0}, {"nameValue", 1, 0.5, 100.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 3, 1.0, 100.0}, {"nameValue", 1, 0.5, 100.0}, {"nameValue", 1, 1.0, 100.0}, {"nameValue", 2, 0.5, 100.0}, {"nameValue", 2, 1.0, 100.0}, {"nameValue", 3, 0.5, 100.0}, {"nameValue", 3, 1.0, 100.0}};
        this.helperTestSweep(expectedValuesChain);
    }

    public void testExpectedOutputSimul() {
        ConstantSetter nameInit = new ConstantSetter("name", (Object)"nameValue");
        IntSteppedSetter intRangeInit = new IntSteppedSetter("intRange", 3, 10, 1);
        DoubleSteppedSetter doubleRangeInit = new DoubleSteppedSetter("doubleRange", 0.5, 1.5, 0.5);
        ListParameterSetter<Double> doubleListInit = new ListParameterSetter<Double>("doubleList", new Double[]{0.0, 0.5, 1.5, 2.0});
        RunParameterSetter runInit = new RunParameterSetter(2);
        ParameterSetter root = this.sweeper.getRootParameterSetter();
        this.sweeper.add(root, runInit);
        this.sweeper.add(runInit, doubleListInit);
        this.sweeper.add(root, doubleRangeInit);
        this.sweeper.add(root, (ParameterSetter)nameInit);
        this.sweeper.add(root, intRangeInit);
        Object[][] expectedValuesSimul = new Object[][]{{"nameValue", 3, 0.5, 0.0}, {"nameValue", 4, 1.0, 0.5}, {"nameValue", 5, 1.5, 1.5}, {"nameValue", 6, 1.5, 2.0}, {"nameValue", 7, 1.5, 0.0}, {"nameValue", 8, 1.5, 0.5}, {"nameValue", 9, 1.5, 1.5}, {"nameValue", 10, 1.5, 2.0}};
        this.helperTestSweep(expectedValuesSimul);
    }
}

