/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.Predicate;
import repast.simphony.engine.graph.EngineGraphUtilities;
import repast.simphony.engine.graph.Executor;
import repast.simphony.engine.graph.NaryTreeTraverser;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.RunParameterSetter;
import repast.simphony.util.collections.NaryTree;
import repast.simphony.util.collections.TreeVisitor;
import simphony.util.messages.MessageCenter;

public class ParameterTreeSweeper
implements ParameterSweeper {
    private static MessageCenter LOG = MessageCenter.getMessageCenter(ParameterTreeSweeper.class);
    protected ParameterSetter rootSetter = new DummyParamSetter();
    protected RunParameterSetter runSetter = new RunParameterSetter(1);
    protected ParameterSetter lastAddedSetter;
    protected boolean firstTime;
    protected NaryTree<ParameterSetter> paramTree = new NaryTree((Object)this.rootSetter);
    protected NaryTreeTraverser<ParameterSetter> traverser;

    public ParameterTreeSweeper() {
        this.paramTree.addNode((Object)this.rootSetter, (Object)this.runSetter);
        this.traverser = new NaryTreeTraverser(this.paramTree);
        this.firstTime = true;
        this.lastAddedSetter = this.runSetter;
    }

    public boolean atEnd() {
        return this.childrenFinished(this.rootSetter);
    }

    public void next(Parameters params) {
        if (this.firstTime) {
            this.firstParameters(params);
            this.firstTime = false;
        } else {
            this.nextParameters(params);
        }
    }

    public void reset(Parameters params) {
        this.firstTime = true;
        this.rootSetter.reset(null);
        this.resetChildren(this.rootSetter, params);
    }

    protected Parameters nextParameters(ParameterSetter init, Parameters params) {
        if (this.paramTree.getChildren((Object)init).size() == 0 || this.childrenFinished(init)) {
            this.nextSelf(init, params);
        } else {
            for (ParameterSetter child : this.paramTree.getChildren((Object)init)) {
                this.nextParameters(child, params);
            }
        }
        return params;
    }

    protected void nextSelf(ParameterSetter init, Parameters params) {
        boolean doReset = !init.atEnd();
        init.next(params);
        if (doReset) {
            this.resetChildren(init, params);
        }
    }

    protected void resetChildren(final ParameterSetter init, final Parameters params) {
        EngineGraphUtilities.breadthFirstMap((Executor)new Executor<ParameterSetter>(){

            public void execute(ParameterSetter toExecuteOn) {
                if (toExecuteOn != init) {
                    toExecuteOn.reset(params);
                }
            }
        }, this.traverser, (Object)init);
    }

    protected boolean childrenFinished(final ParameterSetter parent) {
        return EngineGraphUtilities.breadthFirstSearch((Predicate)new Predicate<ParameterSetter>(){
            private static final long serialVersionUID = 5701489867964980769L;

            public boolean evaluate(ParameterSetter init) {
                return init != parent && !init.atEnd();
            }
        }, this.traverser, (Object)parent) == null;
    }

    protected Parameters nextParameters(Parameters params) {
        return this.nextParameters(this.rootSetter, params);
    }

    protected Parameters firstParameters(final Parameters params) {
        this.paramTree.preOrderTraversal((TreeVisitor)new TreeVisitor<ParameterSetter>(){

            public void visit(ParameterSetter node) {
                if (node != ParameterTreeSweeper.this.rootSetter) {
                    node.reset(params);
                }
            }
        });
        return params;
    }

    @Override
    public void add(ParameterSetter parent, ParameterSetter setter) {
        if (parent == null || setter == null) {
            IllegalArgumentException ex = new IllegalArgumentException("param cannot be null");
            LOG.error((Object)"Cannot pass in a null parameter name to a sweeper's add method.", (Throwable)ex, new Object[0]);
            throw ex;
        }
        this.paramTree.addNode((Object)parent, (Object)setter);
    }

    public void add(ParameterSetter setter) {
        this.paramTree.addNode((Object)this.lastAddedSetter, (Object)setter);
        this.lastAddedSetter = setter;
    }

    public void addToRoot(ParameterSetter setter) {
        this.add(this.getRootParameterSetter(), setter);
    }

    @Override
    public void remove(ParameterSetter setter) {
        this.paramTree.removeNode((Object)setter);
    }

    public void addIntRange(String param, int base, int max, int step) {
        IntSteppedSetter init = new IntSteppedSetter(param, base, max, step);
        this.add(init);
    }

    public void addDoubleRange(String param, double base, double max, double step) {
        DoubleSteppedSetter init = new DoubleSteppedSetter(param, base, max, step);
        this.add(init);
    }

    public void setRunCount(int count) {
        RunParameterSetter tmp = new RunParameterSetter(count);
        this.paramTree.replaceNode((Object)this.runSetter, (Object)tmp);
        this.runSetter = tmp;
    }

    public int getRunCount() {
        return this.runSetter.getTotalRuns();
    }

    @Override
    public ParameterSetter getRootParameterSetter() {
        return this.runSetter;
    }

    @Override
    public Collection<ParameterSetter> getChildren(ParameterSetter parentSetter) {
        return this.paramTree.getChildren((Object)parentSetter);
    }

    public String toStringChildren(ParameterSetter setter) {
        String res = setter + " {";
        Collection children = this.paramTree.getChildren((Object)setter);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            ParameterSetter childInit = (ParameterSetter)iterator.next();
            res = String.valueOf(res) + this.toStringChildren(childInit);
            if (!iterator.hasNext()) continue;
            res = String.valueOf(res) + ",";
        }
        return String.valueOf(res) + "}";
    }

    public String toString() {
        return this.toStringChildren(this.rootSetter);
    }

    class DummyParamSetter
    implements ParameterSetter {
        DummyParamSetter() {
        }

        public void reset(Parameters params) {
        }

        public boolean atEnd() {
            return true;
        }

        public void next(Parameters params) {
        }

        public String toString() {
            return "[root]";
        }
    }
}

