/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.FloatSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.LongSteppedSetter;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterSweeperBuilder;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;

public class ParameterSweeperBuilderTest
extends TestCase {
    private ParameterSweeperBuilder builder;

    public void setUp() {
        this.builder = new ParameterSweeperBuilder();
    }

    public void testRuns() {
        this.builder.setRunCount(3);
        ParameterSweeperBuilderTest.assertEquals((int)3, (int)this.builder.getSweeper().getRunCount());
    }

    public void testIntStepper() {
        ParameterSetter setter = this.builder.addStepper("p", 1, 3, 1);
        Parameters params = this.builder.getParameters();
        setter.reset(params);
        ParameterSweeperBuilderTest.assertEquals((Object)1, (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)2, (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)3, (Object)params.getValue("p"));
        ParameterSweeperBuilderTest.assertTrue((boolean)setter.atEnd());
        ParameterSweeperBuilderTest.assertTrue((boolean)(setter instanceof IntSteppedSetter));
        ParameterSweeperBuilderTest.assertEquals((Object)setter, (Object)this.builder.getSetter("p"));
    }

    public void testDoubleStepper() {
        ParameterSetter setter = this.builder.addStepper("p", 1.0, 1.2, 0.1);
        Parameters params = this.builder.getParameters();
        setter.reset(params);
        ParameterSweeperBuilderTest.assertEquals((Object)1.0, (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)1.1, (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)1.2, (Object)params.getValue("p"));
        ParameterSweeperBuilderTest.assertTrue((boolean)setter.atEnd());
        ParameterSweeperBuilderTest.assertTrue((boolean)(setter instanceof DoubleSteppedSetter));
        ParameterSweeperBuilderTest.assertEquals((Object)setter, (Object)this.builder.getSetter("p"));
    }

    public void testDoubleStepper2() {
        ParameterSetter setter = this.builder.addStepper("p", 1.0, 3.0, 1.0);
        Parameters params = this.builder.getParameters();
        setter.reset(params);
        ParameterSweeperBuilderTest.assertEquals((Object)new Double(1.0), (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)new Double(2.0), (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)new Double(3.0), (Object)params.getValue("p"));
        ParameterSweeperBuilderTest.assertTrue((boolean)setter.atEnd());
        ParameterSweeperBuilderTest.assertTrue((boolean)(setter instanceof DoubleSteppedSetter));
        ParameterSweeperBuilderTest.assertEquals((Object)setter, (Object)this.builder.getSetter("p"));
    }

    public void testFloatStepper() {
        ParameterSetter setter = this.builder.addStepper("p", 1.0f, 1.2f, 0.1f);
        Parameters params = this.builder.getParameters();
        setter.reset(params);
        ParameterSweeperBuilderTest.assertEquals((Object)Float.valueOf(1.0f), (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)Float.valueOf(1.1f), (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)Float.valueOf(1.2f), (Object)params.getValue("p"));
        ParameterSweeperBuilderTest.assertTrue((boolean)setter.atEnd());
        ParameterSweeperBuilderTest.assertTrue((boolean)(setter instanceof FloatSteppedSetter));
        ParameterSweeperBuilderTest.assertEquals((Object)setter, (Object)this.builder.getSetter("p"));
    }

    public void testLongStepper() {
        ParameterSetter setter = this.builder.addStepper("p", 1L, 3L, 1L);
        Parameters params = this.builder.getParameters();
        setter.reset(params);
        ParameterSweeperBuilderTest.assertEquals((Object)1L, (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)2L, (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)3L, (Object)params.getValue("p"));
        ParameterSweeperBuilderTest.assertTrue((boolean)setter.atEnd());
        ParameterSweeperBuilderTest.assertTrue((boolean)(setter instanceof LongSteppedSetter));
        ParameterSweeperBuilderTest.assertEquals((Object)setter, (Object)this.builder.getSetter("p"));
    }

    public void testListSetter() {
        ParameterSetter setter = this.builder.addListSetter("p", new String[]{"cormac", "nicola", "me"});
        Parameters params = this.builder.getParameters();
        setter.reset(params);
        ParameterSweeperBuilderTest.assertEquals((Object)"cormac", (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)"nicola", (Object)params.getValue("p"));
        setter.next(params);
        ParameterSweeperBuilderTest.assertEquals((Object)"me", (Object)params.getValue("p"));
        ParameterSweeperBuilderTest.assertTrue((boolean)setter.atEnd());
        ParameterSweeperBuilderTest.assertTrue((boolean)(setter instanceof ListParameterSetter));
        ParameterSweeperBuilderTest.assertEquals((Object)setter, (Object)this.builder.getSetter("p"));
    }

    public void testParameterTree() {
        try {
            ParameterSweeperBuilder builder = new ParameterSweeperBuilder();
            builder.setRunCount(2);
            builder.addConstant("const_1", Float.valueOf(0.3f));
            builder.addConstant("const_2", 0.2);
            builder.addConstant("const_3", 11);
            builder.addConstant("const_4", 11L);
            builder.addConstant("const_5", "hello cormac");
            builder.addConstant("const_6", false);
            ParameterSetter top = builder.addStepper("num_1", 1L, 4L, 1L);
            ParameterSetter num_2 = builder.addStepper("num_2", 0.3f, 1.0f, 0.1f);
            builder.addListSetter(num_2, "list_val", new String[]{"foo", "bar", "baz"});
            builder.addStepper(top, "num_3", 0.9, 1.0, 0.1);
            builder.addStepper(top, "num_4", 2, 3, 1);
            ParameterTreeSweeper sweeper = builder.getSweeper();
            ParameterSweeperBuilderTest.assertEquals((int)2, (int)sweeper.getRunCount());
            ParameterSetter root = sweeper.getRootParameterSetter();
            Collection<ParameterSetter> children = sweeper.getChildren(root);
            ParameterSweeperBuilderTest.assertEquals((int)7, (int)children.size());
            HashSet<String> names = new HashSet<String>();
            LongSteppedSetter iSetter = null;
            for (ParameterSetter setter : children) {
                if (setter instanceof LongSteppedSetter) {
                    iSetter = (LongSteppedSetter)setter;
                    names.add(((LongSteppedSetter)setter).getParameterName());
                }
                if (!(setter instanceof ConstantSetter)) continue;
                names.add(((ConstantSetter)setter).getParameterName());
            }
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("num_1"));
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("const_1"));
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("const_2"));
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("const_3"));
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("const_4"));
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("const_5"));
            ParameterSweeperBuilderTest.assertTrue((boolean)names.contains("const_6"));
            ParameterSweeperBuilderTest.assertEquals((String)"num_1", (String)iSetter.getParameterName());
            children = sweeper.getChildren(iSetter);
            ParameterSweeperBuilderTest.assertEquals((int)3, (int)children.size());
            HashSet<Class<IntSteppedSetter>> types = new HashSet<Class<IntSteppedSetter>>();
            types.add(DoubleSteppedSetter.class);
            types.add(FloatSteppedSetter.class);
            types.add(IntSteppedSetter.class);
            HashMap<String, ParameterSetter> map = new HashMap<String, ParameterSetter>();
            for (ParameterSetter ps : children) {
                ParameterSweeperBuilderTest.assertTrue((boolean)types.remove(ps.getClass()));
                if (ps instanceof DoubleSteppedSetter) {
                    map.put(((DoubleSteppedSetter)ps).getParameterName(), ps);
                }
                if (ps instanceof FloatSteppedSetter) {
                    map.put(((FloatSteppedSetter)ps).getParameterName(), ps);
                }
                if (!(ps instanceof IntSteppedSetter)) continue;
                map.put(((IntSteppedSetter)ps).getParameterName(), ps);
            }
            ParameterSweeperBuilderTest.assertEquals((int)0, (int)types.size());
            ParameterSweeperBuilderTest.assertTrue((boolean)map.containsKey("num_2"));
            ParameterSweeperBuilderTest.assertTrue((boolean)map.containsKey("num_3"));
            ParameterSweeperBuilderTest.assertTrue((boolean)map.containsKey("num_4"));
            children = sweeper.getChildren((ParameterSetter)map.get("num_2"));
            ParameterSweeperBuilderTest.assertEquals((int)1, (int)children.size());
            ListParameterSetter lSetter = (ListParameterSetter)children.iterator().next();
            ParameterSweeperBuilderTest.assertEquals((String)"list_val", (String)lSetter.getParameterName());
            children = sweeper.getChildren(lSetter);
            ParameterSweeperBuilderTest.assertEquals((int)0, (int)children.size());
            children = sweeper.getChildren((ParameterSetter)map.get("num_3"));
            ParameterSweeperBuilderTest.assertEquals((int)0, (int)children.size());
            children = sweeper.getChildren((ParameterSetter)map.get("num_4"));
            ParameterSweeperBuilderTest.assertEquals((int)0, (int)children.size());
            Parameters params = builder.getParameters();
            names = new HashSet();
            names.add("num_1");
            names.add("num_2");
            names.add("num_3");
            names.add("num_4");
            names.add("list_val");
            names.add("const_1");
            names.add("const_2");
            names.add("const_3");
            names.add("const_4");
            names.add("const_5");
            names.add("const_6");
            for (String name : params.getSchema().parameterNames()) {
                ParameterSweeperBuilderTest.assertTrue((boolean)names.remove(name));
            }
            ParameterSweeperBuilderTest.assertEquals((Object)new Long(1L), (Object)params.getValue("num_1"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Float(0.3), (Object)params.getValue("num_2"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Double(0.9), (Object)params.getValue("num_3"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Integer(2), (Object)params.getValue("num_4"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Float(0.3f), (Object)params.getValue("const_1"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Double(0.2), (Object)params.getValue("const_2"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Integer(11), (Object)params.getValue("const_3"));
            ParameterSweeperBuilderTest.assertEquals((Object)new Long(11L), (Object)params.getValue("const_4"));
            ParameterSweeperBuilderTest.assertEquals((Object)"hello cormac", (Object)params.getValue("const_5"));
            ParameterSweeperBuilderTest.assertEquals((Object)Boolean.FALSE, (Object)params.getValue("const_6"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ParameterSweeperBuilderTest.assertTrue((boolean)false);
        }
    }
}

