/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.FloatSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.LongSteppedSetter;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;

public class ParameterSweeperBuilder {
    private ParameterTreeSweeper sweeper = new ParameterTreeSweeper();
    private Map<String, ParameterSetter> setterMap = new HashMap<String, ParameterSetter>();
    private ParametersCreator creator = new ParametersCreator();
    private ParameterSetter lastSetter;

    public ParameterSweeperBuilder() {
    }

    public ParameterSweeperBuilder(ParameterTreeSweeper sweeper) {
        this.sweeper = sweeper;
    }

    public ParameterSetter getRootSetter() {
        return this.sweeper.getRootParameterSetter();
    }

    public void setRunCount(int runs) {
        this.sweeper.setRunCount(runs);
    }

    public <T> ParameterSetter addConstant(String name, T value) {
        ConstantSetter setter = new ConstantSetter(name, value);
        this.creator.addParameter(name, value.getClass(), value, false);
        this.addSetter(this.sweeper.getRootParameterSetter(), (ParameterSetter)setter);
        this.lastSetter = null;
        return setter;
    }

    public ParameterSetter addStepper(String name, int start, int end, int step) {
        IntSteppedSetter setter = this.createIntStepper(name, start, end, step);
        this.addSetter(null, setter);
        return setter;
    }

    private IntSteppedSetter createIntStepper(String name, int start, int end, int step) {
        IntSteppedSetter setter = new IntSteppedSetter(name, start, end, step);
        this.setterMap.put(name, setter);
        this.creator.addParameter(name, Integer.class, (Object)start, false);
        return setter;
    }

    public ParameterSetter addStepper(ParameterSetter parent, String name, int start, int end, int step) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent Stepper cannot be null");
        }
        IntSteppedSetter setter = this.createIntStepper(name, start, end, step);
        this.addSetter(parent, setter);
        return setter;
    }

    public ParameterSetter addStepper(String name, double start, double end, double step) {
        DoubleSteppedSetter setter = this.createDoubleStepper(name, start, end, step);
        this.addSetter(null, setter);
        return setter;
    }

    private DoubleSteppedSetter createDoubleStepper(String name, double start, double end, double step) {
        DoubleSteppedSetter setter = new DoubleSteppedSetter(name, start, end, step);
        this.setterMap.put(name, setter);
        this.creator.addParameter(name, Double.class, (Object)start, false);
        return setter;
    }

    public ParameterSetter addStepper(ParameterSetter parent, String name, double start, double end, double step) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent Stepper cannot be null");
        }
        DoubleSteppedSetter setter = this.createDoubleStepper(name, start, end, step);
        this.addSetter(parent, setter);
        return setter;
    }

    public ParameterSetter addStepper(String name, float start, float end, float step) {
        FloatSteppedSetter setter = this.createFloatStepper(name, start, end, step);
        this.addSetter(null, setter);
        return setter;
    }

    private FloatSteppedSetter createFloatStepper(String name, float start, float end, float step) {
        FloatSteppedSetter setter = new FloatSteppedSetter(name, start, end, step);
        this.setterMap.put(name, setter);
        this.creator.addParameter(name, Float.class, (Object)Float.valueOf(start), false);
        return setter;
    }

    public ParameterSetter addStepper(ParameterSetter parent, String name, float start, float end, float step) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent Stepper cannot be null");
        }
        FloatSteppedSetter setter = this.createFloatStepper(name, start, end, step);
        this.addSetter(parent, setter);
        return setter;
    }

    public ParameterSetter addStepper(String name, long start, long end, long step) {
        LongSteppedSetter setter = this.createLongStepper(name, start, end, step);
        this.addSetter(null, setter);
        return setter;
    }

    private LongSteppedSetter createLongStepper(String name, long start, long end, long step) {
        LongSteppedSetter setter = new LongSteppedSetter(name, start, end, step);
        this.setterMap.put(name, setter);
        this.creator.addParameter(name, Long.class, (Object)start, false);
        return setter;
    }

    public ParameterSetter addStepper(ParameterSetter parent, String name, long start, long end, long step) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent Stepper cannot be null");
        }
        LongSteppedSetter setter = this.createLongStepper(name, start, end, step);
        this.addSetter(parent, setter);
        return setter;
    }

    public <T> ParameterSetter addListSetter(String name, T[] list) {
        ListParameterSetter<T> setter = new ListParameterSetter<T>(name, list);
        this.setterMap.put(name, setter);
        this.creator.addParameter(name, list[0].getClass(), list[0], false);
        this.addSetter(null, setter);
        return setter;
    }

    public <T> ParameterSetter addListSetter(ParameterSetter parent, String name, T[] list) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent Stepper cannot be null");
        }
        ListParameterSetter<T> setter = new ListParameterSetter<T>(name, list);
        this.setterMap.put(name, setter);
        this.creator.addParameter(name, list[0].getClass(), list[0], false);
        this.addSetter(parent, setter);
        return setter;
    }

    public ParameterSetter getSetter(String name) {
        return this.setterMap.get(name);
    }

    private void addSetter(ParameterSetter parent, ParameterSetter toAdd) {
        if (parent == null) {
            parent = this.lastSetter == null ? this.sweeper.getRootParameterSetter() : this.lastSetter;
        }
        this.sweeper.add(parent, toAdd);
        this.lastSetter = toAdd;
    }

    public ParameterTreeSweeper getSweeper() {
        return this.sweeper;
    }

    public Parameters getParameters() {
        return this.creator.createParameters();
    }
}

