/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import junit.framework.TestCase;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.engine.controller.DefaultControllerRegistry;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunState;
import repast.simphony.parameter.ConstantSetter;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.RunResultProducer;
import repast.simphony.parameter.optimizer.AdvanceType;
import repast.simphony.parameter.optimizer.AdvancementChooser;
import repast.simphony.parameter.optimizer.AnnealingAdvancementChooser;
import repast.simphony.parameter.optimizer.HillClimber;
import repast.simphony.parameter.optimizer.OptimizedParameterSweeper;
import repast.simphony.random.RandomHelper;

public class OptimizedParameterTest
extends TestCase {
    private static final String MASTER_ID = "masterid";
    private ConstantSetter<String> nameInit;
    private IntSteppedSetter intRangeInit;
    private ListParameterSetter<Double> doubleListInit;
    private OptimizedParameterSweeper sweeper;
    private RunState runState;
    private DoubleSteppedSetter doubleRangeInit;
    private Parameters params;

    protected void setUp() throws Exception {
        this.nameInit = new ConstantSetter("name", (Object)"nameValue");
        this.intRangeInit = new IntSteppedSetter("intRange", 0, 10, 1);
        this.doubleListInit = new ListParameterSetter<Double>("doubleList", new Double[]{0.0, 0.5, 1.5, 2.0});
        this.doubleRangeInit = new DoubleSteppedSetter("doubleRange", 0.0, 1.0, 0.5);
        this.runState = RunState.init();
        this.runState.setMasterContext((Context)new DefaultContext((Object)MASTER_ID));
        this.runState.setControllerRegistry((ControllerRegistry)new DefaultControllerRegistry());
        this.sweeper = new OptimizedParameterSweeper(this.runState.getControllerRegistry(), MASTER_ID);
        ParameterSetter root = this.sweeper.getRootParameterSetter();
        this.sweeper.add(root, this.doubleListInit);
        this.sweeper.add(this.doubleListInit, this.doubleRangeInit);
        this.sweeper.add(root, (ParameterSetter)this.nameInit);
        this.sweeper.add(root, this.intRangeInit);
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("name", String.class, (Object)"nameValue", false);
        creator.addParameter("intRange", Integer.class, (Object)0, false);
        creator.addParameter("doubleList", Double.class, (Object)0.0, false);
        creator.addParameter("doubleRange", Double.class, (Object)0.0, false);
        creator.addParameter("x", Integer.class, (Object)0, false);
        creator.addParameter("y", Integer.class, (Object)0, false);
        this.params = creator.createParameters();
    }

    public void testExpectedOutput() {
        Object[][] expectedValues = new Object[][]{{"nameValue", 0, 0.0, 0.0}, {"nameValue", 0, 0.0, 0.5}, {"nameValue", 0, 0.0, 1.0}, {"nameValue", 1, 0.0, 1.0}, {"nameValue", 2, 0.0, 1.0}, {"nameValue", 3, 0.0, 1.0}, {"nameValue", 4, 0.0, 1.0}, {"nameValue", 5, 0.0, 1.0}, {"nameValue", 6, 0.0, 1.0}, {"nameValue", 7, 0.0, 1.0}, {"nameValue", 8, 0.0, 1.0}, {"nameValue", 9, 0.0, 1.0}, {"nameValue", 10, 0.0, 1.0}, {"nameValue", 10, 0.5, 1.0}, {"nameValue", 10, 1.5, 1.0}, {"nameValue", 10, 2.0, 1.0}};
        int i = 0;
        while (i < expectedValues.length) {
            OptimizedParameterTest.assertTrue((!this.sweeper.atEnd() ? 1 : 0) != 0);
            this.sweeper.next(this.params);
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][0], (Object)this.params.getValue("name"));
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][1], (Object)this.params.getValue("intRange"));
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][2], (Object)this.params.getValue("doubleList"));
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][3], (Object)this.params.getValue("doubleRange"));
            ++i;
        }
        this.sweeper.next(this.params);
        OptimizedParameterTest.assertFalse((!this.sweeper.atEnd() ? 1 : 0) != 0);
    }

    public void testWithRevert() {
        Object[][] expectedValues = new Object[][]{{"nameValue", 0, 0.0, 0.0}, {"nameValue", 0, 0.0, 0.5}, {"nameValue", 0, 0.0, 1.0}, {"nameValue", 1, 0.0, 1.0}, {"nameValue", 2, 0.0, 1.0}, {"nameValue", 0, 0.0, 1.0}, {"nameValue", 1, 0.0, 1.0}, {"nameValue", 2, 0.0, 1.0}, {"nameValue", 3, 0.0, 1.0}, {"nameValue", 4, 0.0, 1.0}, {"nameValue", 5, 0.0, 1.0}, {"nameValue", 6, 0.0, 1.0}, {"nameValue", 7, 0.0, 1.0}, {"nameValue", 8, 0.0, 1.0}, {"nameValue", 9, 0.0, 1.0}, {"nameValue", 10, 0.0, 1.0}, {"nameValue", 10, 0.5, 1.0}, {"nameValue", 10, 1.5, 1.0}, {"nameValue", 10, 2.0, 1.0}};
        AdvancementChooser defaultChooser = this.sweeper.getAdvancementChooser();
        AdvancementChooser backTrackChooser = new AdvancementChooser(){

            @Override
            public boolean shouldRevert(double runResult) {
                return true;
            }

            @Override
            public AdvanceType chooseAdvancement(ParameterSetter initializer, AdvanceType lastType, double runResult) {
                return AdvanceType.BACKWARD;
            }
        };
        int i = 0;
        while (i < expectedValues.length) {
            if (i == 5) {
                this.sweeper.setAdvancementChooser(backTrackChooser);
            } else if (i == 6) {
                this.sweeper.setAdvancementChooser(defaultChooser);
            }
            OptimizedParameterTest.assertTrue((!this.sweeper.atEnd() ? 1 : 0) != 0);
            this.sweeper.next(this.params);
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][0], (Object)this.params.getValue("name"));
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][1], (Object)this.params.getValue("intRange"));
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][2], (Object)this.params.getValue("doubleList"));
            OptimizedParameterTest.assertEquals((Object)expectedValues[i][3], (Object)this.params.getValue("doubleRange"));
            ++i;
        }
        this.sweeper.next(this.params);
        OptimizedParameterTest.assertFalse((!this.sweeper.atEnd() ? 1 : 0) != 0);
    }

    public void testHill() {
        int xCenter = 20;
        int yCenter = 25;
        this.sweeper.setResultProducer(new RunResultProducer(){

            @Override
            public double getRunValue(RunState runState) {
                Parameters params = RunEnvironment.getInstance().getParameters();
                double x = (Integer)params.getValue("x") - 20;
                double y = (Integer)params.getValue("y") - 25;
                return -(x * x + y * y);
            }
        });
        RunEnvironment.init(null, null, (Parameters)this.params, (boolean)false);
        ControllerAction runResultAction = (ControllerAction)this.runState.getControllerRegistry().getActionTree((Object)MASTER_ID).getChildren((Object)ControllerRegistry.ACTION_TREE_ROOT).iterator().next();
        this.sweeper.setAdvancementChooser(new HillClimber());
        this.sweeper.addToRoot(new IntSteppedSetter("x", 0, 40, 1));
        this.sweeper.addToRoot(new IntSteppedSetter("y", 0, 40, 1));
        while (!this.sweeper.atEnd()) {
            this.sweeper.next(this.params);
            runResultAction.runCleanup(this.runState, (Object)MASTER_ID);
        }
        OptimizedParameterTest.assertEquals((Object)20, (Object)this.params.getValue("x"));
        OptimizedParameterTest.assertEquals((Object)25, (Object)this.params.getValue("y"));
    }

    public void testHillRandomStart() {
        System.out.println("testHillRandomStart");
        RandomHelper.setSeed((int)((int)System.currentTimeMillis()));
        System.out.println(RandomHelper.getSeed());
        this.sweeper.setFirstStepRandom(true);
        this.testHill();
    }

    public void testRepeatedlyHillRandomStart() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.setUp();
            this.testHillRandomStart();
            ++i;
        }
    }

    public void testAnnealingSingleHill() {
        System.out.println("testAnnealingSingleHill");
        int xCenter = 20;
        int yCenter = 25;
        this.sweeper.setResultProducer(new RunResultProducer(){

            @Override
            public double getRunValue(RunState runState) {
                Parameters params = RunEnvironment.getInstance().getParameters();
                double x = (Integer)params.getValue("x") - 20;
                double y = (Integer)params.getValue("y") - 25;
                return -(x * x + y * y);
            }
        });
        RunEnvironment.init(null, null, (Parameters)this.params, (boolean)false);
        ControllerAction runResultAction = (ControllerAction)this.runState.getControllerRegistry().getActionTree((Object)MASTER_ID).getChildren((Object)ControllerRegistry.ACTION_TREE_ROOT).iterator().next();
        this.sweeper.setAdvancementChooser(new AnnealingAdvancementChooser());
        this.sweeper.addToRoot(new IntSteppedSetter("x", 0, 40, 1));
        this.sweeper.addToRoot(new IntSteppedSetter("y", 0, 40, 1));
        RandomHelper.setSeed((int)((int)System.currentTimeMillis()));
        System.out.println(RandomHelper.getSeed());
        while (!this.sweeper.atEnd()) {
            this.sweeper.next(this.params);
            runResultAction.runCleanup(this.runState, (Object)MASTER_ID);
        }
        OptimizedParameterTest.assertEquals((Object)20, (Object)this.params.getValue("x"));
        OptimizedParameterTest.assertEquals((Object)25, (Object)this.params.getValue("y"));
    }

    public void testAnnealingRepeatedly() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.setUp();
            this.testAnnealingSingleHill();
            ++i;
        }
    }

    public void testHillMultipleHill1() {
        System.out.println("testHillMultipleHill1");
        this.sweeper.setResultProducer(new RunResultProducer(){

            @Override
            public double getRunValue(RunState runState) {
                Parameters params = RunEnvironment.getInstance().getParameters();
                double x = ((Integer)params.getValue("x")).intValue();
                return (x - 10.0) * (x - 30.0) * (x - 15.0) * x * (x - 25.0) / 400.0;
            }
        });
        RunEnvironment.init(null, null, (Parameters)this.params, (boolean)false);
        ControllerAction runResultAction = (ControllerAction)this.runState.getControllerRegistry().getActionTree((Object)MASTER_ID).getChildren((Object)ControllerRegistry.ACTION_TREE_ROOT).iterator().next();
        this.sweeper.setAdvancementChooser(new HillClimber());
        this.sweeper.addToRoot(new IntSteppedSetter("x", 0, 30, 1));
        this.sweeper.addToRoot(new IntSteppedSetter("y", 0, 30, 1));
        RandomHelper.setSeed((int)((int)System.currentTimeMillis()));
        System.out.println(RandomHelper.getSeed());
        while (!this.sweeper.atEnd()) {
            this.sweeper.next(this.params);
            runResultAction.runCleanup(this.runState, (Object)MASTER_ID);
        }
        OptimizedParameterTest.assertEquals((Object)3, (Object)this.params.getValue("x"));
    }

    public void testHillMultipleHill2() {
        System.out.println("testHillMultipleHill2");
        this.sweeper.setResultProducer(new RunResultProducer(){

            @Override
            public double getRunValue(RunState runState) {
                Parameters params = RunEnvironment.getInstance().getParameters();
                double x = ((Integer)params.getValue("x")).intValue();
                return (x - 10.0) * (x - 30.0) * (x - 15.0) * x * (x - 25.0) / 400.0;
            }
        });
        RunEnvironment.init(null, null, (Parameters)this.params, (boolean)false);
        ControllerAction runResultAction = (ControllerAction)this.runState.getControllerRegistry().getActionTree((Object)MASTER_ID).getChildren((Object)ControllerRegistry.ACTION_TREE_ROOT).iterator().next();
        this.sweeper.setAdvancementChooser(new HillClimber());
        this.sweeper.addToRoot(new IntSteppedSetter("x", 15, 30, 1));
        this.sweeper.addToRoot(new IntSteppedSetter("y", 0, 30, 1));
        RandomHelper.setSeed((int)((int)System.currentTimeMillis()));
        System.out.println(RandomHelper.getSeed());
        while (!this.sweeper.atEnd()) {
            this.sweeper.next(this.params);
            runResultAction.runCleanup(this.runState, (Object)MASTER_ID);
        }
        OptimizedParameterTest.assertEquals((Object)20, (Object)this.params.getValue("x"));
    }

    public void testAnnealingMultipleHill() {
        System.out.println("testAnnealingMultipleHill");
        this.sweeper.setResultProducer(new RunResultProducer(){

            @Override
            public double getRunValue(RunState runState) {
                Parameters params = RunEnvironment.getInstance().getParameters();
                double x = ((Integer)params.getValue("x")).intValue();
                return (x - 10.0) * (x - 30.0) * (x - 15.0) * x * (x - 25.0) / 400.0;
            }
        });
        RunEnvironment.init(null, null, (Parameters)this.params, (boolean)false);
        ControllerAction runResultAction = (ControllerAction)this.runState.getControllerRegistry().getActionTree((Object)MASTER_ID).getChildren((Object)ControllerRegistry.ACTION_TREE_ROOT).iterator().next();
        this.sweeper.setAdvancementChooser(new AnnealingAdvancementChooser());
        this.sweeper.addToRoot(new IntSteppedSetter("x", 0, 40, 1));
        this.sweeper.addToRoot(new IntSteppedSetter("y", 0, 40, 1));
        RandomHelper.setSeed((int)((int)System.currentTimeMillis()));
        System.out.println(RandomHelper.getSeed());
        while (!this.sweeper.atEnd()) {
            this.sweeper.next(this.params);
            runResultAction.runCleanup(this.runState, (Object)MASTER_ID);
        }
        int xValue = (Integer)this.params.getValue("x");
        System.out.println(xValue);
        OptimizedParameterTest.assertTrue((String)Integer.toString(xValue), (xValue == 40 || xValue == 3 || xValue == 20 ? 1 : 0) != 0);
    }

    public void testAnnealMultHillRepeatedly() throws Exception {
        int i = 0;
        while (i < 100) {
            this.setUp();
            this.testAnnealingMultipleHill();
            ++i;
        }
    }
}

