/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import repast.simphony.parameter.AbstractSweepParameterSetter;

public class LongSteppedSetter
extends AbstractSweepParameterSetter<Long> {
    private long stepSize;
    private long max;
    private long base;

    public LongSteppedSetter(String parameterName, long base, long max, long step) {
        super(parameterName);
        this.base = base;
        this.stepSize = step;
        this.max = max;
    }

    @Override
    public Long resetValue() {
        return this.base;
    }

    @Override
    public boolean atEnd(Long prevValue) {
        if (prevValue == null) {
            return false;
        }
        return prevValue + this.stepSize > this.max;
    }

    @Override
    public boolean atBeginning(Long prevValue) {
        if (prevValue == null) {
            return true;
        }
        return prevValue - this.stepSize < this.base;
    }

    @Override
    protected Long nextValue(Long prevValue) {
        if (prevValue == null) {
            prevValue = this.base;
        }
        return prevValue + this.stepSize;
    }

    @Override
    protected Long randomValue() {
        int numSteps = (int)Math.floor((this.max - this.base) / this.stepSize);
        int steps = this.randInt(0, numSteps);
        return (long)steps * this.stepSize + this.base;
    }

    @Override
    protected Long previousValue(Long prevValue) {
        if (prevValue == null) {
            prevValue = this.base + this.stepSize;
        }
        return prevValue - this.stepSize;
    }

    public String toString() {
        return "[long " + this.parameterName + " " + this.base + ".." + this.max + "," + this.stepSize + "]";
    }
}

